#include <dic.hxx>
#include <iostream>
#include <vector>
#include <string>
#include <fstream>
#include <memory>

#include "DAQInterface.hh"
#include "Hist2DMap.hh"
#include "RedisIO.hh"
#include "Earthworm.hh"
#include "RedisNumpy.hh"

int main()
{
	// int cmd = rio.readInt("/SANS/control/command/drone");
	// std::cout << cmd << '\n';
	// EW_LOG_INFO("cmd is {}", cmd);
	//
	// std::string detconf = rio.readString("/MR/control/configure");
	// //  _configure['mode']
	// EW_LOG_INFO("detconf is {}", detconf);
	//
	// //std::string s = j.dump();    // {\"happy\":true,\"pi\":3.141}
	//
	//
	// auto j = nlohmann::json::parse(detconf);
	// std::string mode = j["mode"];
	// EW_LOG_INFO("det is {}", mode);
	//
	//
	// abort();

	std::cout << "Starting client..." << std::endl;
  unsigned pid_num(300), tof_num(2500);

	std::shared_ptr<RedisIO> redis(
		new RedisIO( 9001, "neonmaster", "sanlie;123"));
  //redis should retrive all parameters
  std::shared_ptr<Hist2DMap> histmap(new Hist2DMap(pid_num, 0, 300, tof_num, 0 , 40000 , Hist2DMap::DetectorType::kHe3) );

  //RunNumber runNumber;
	DAQInterface *daq =  new DAQInterface("/sim/dimserver/TEST_SWAP_1",1000);
	daq->setActive(true);
  daq->setHist2DMap(histmap);

	std::vector<double> pid;
	for(unsigned i=0;i<pid_num*4;i++)
	  pid.push_back(i+1);
	RedisNumpy nvt;
  std::string pidstr;
	std::vector<uint64_t> shape;
	shape.push_back(pid_num*4);
	nvt.makeNumpyArr(pid, RedisNumpy::data_type::f8,
									 shape, pidstr);
	// redis->writeString("/sim/MR/workspace/detector/module1/pid", pidstr);

	std::vector<double> tof;
	for(unsigned i=0;i<tof_num+1;i++)
	{
		tof.push_back(i*16);
	}
	std::string tofstr;
	shape[0]=(tof_num+1);
	nvt.makeNumpyArr(tof, RedisNumpy::data_type::f8,
									 shape, tofstr);
	//redis->writeString("/sim/MR/workspace/detector/module1/tof", tofstr);

	auto start = std::chrono::steady_clock::now();


	unsigned loop=10;
	while(!daq->terminated())
	{
		std::this_thread::sleep_for(std::chrono::milliseconds(1000));

		loop--;
    std::string str;

		//histmap->merge(str);
		histmap->makeNumpyRaw(str);
		//redis->writeString("/sim/MR/workspace/detector/module1/value", str);

    EW_LOG_INFO("Data integral {}", histmap->getIntegral());
	}
	EW_LOG_INFO("loop breaking");


	double t=std::chrono::duration_cast<std::chrono::seconds>(std::chrono::steady_clock::now()
	             - start).count();
  std::cout << "speed is "  << t/100 << "s per loop\n"
	<< histmap->getIntegral()/t << "event/s \n";
  if(daq)	delete daq;
  return 0;
}
