#ifndef DimRecv_DaqTask_hh
#define DimRecv_DaqTask_hh

#include <future>
#include <vector>
#include <mutex>

#include "Hist2DMap.hh"

class DaqTask {
public:
  DaqTask(uint8_t* begin, uint8_t* end, const std::shared_ptr<Hist2DMap>& map);
  DaqTask(uint8_t* begin, uint8_t* end);
  virtual ~DaqTask();

  // Move initialization
  DaqTask(DaqTask&& other) ;
  // Copy initialization
  DaqTask(const DaqTask& other) = delete;
  // Move assignment
  DaqTask& operator = (DaqTask&& other) ;
  // Copy assignment
  DaqTask& operator = (const DaqTask& other) = delete;


  //returns non-zero value if a data package is analysed
  //the first 32-bit is the processed event number
  //the rest is the processed bytes
  uint64_t readyAndValid();
  void start();
  void setTime(int second, int ms);
  void getTime(int &second, int &ms) const;


private:
  std::vector<uint8_t> m_data;
  std::shared_future<uint64_t> m_future;
  int m_time_s, m_time_ms; //package stamped time, since 1/1/1970, in seconds
  mutable std::mutex m_run_mutex;
  std::shared_ptr<Hist2DMap> m_hist_map;

  //the actual workload
  uint64_t run();
};

#endif
