#!/usr/bin/python

from __future__ import print_function
import vacf
import time
import sys
import h5py
import numpy as np
from multiprocessing import Pool
import matplotlib.pyplot as plt

fname = 'lammp/dump_h5md.h5'
if len(sys.argv)==2:
    fname = sys.argv[1]

f=h5py.File(fname,'r')

#For style real, these are the units:
#mass = grams/mole
#distance = Angstroms
#time = femtoseconds
#energy = Kcal/mole
#velocity = Angstroms/femtosecond
#force = Kcal/mole-Angstrom
#torque = Kcal/mole
#temperature = Kelvin
#pressure = atmospheres
#dynamic viscosity = Poise
#charge = multiple of electron charge (1.0 is a proton)
#dipole = charge*Angstroms
#electric field = volts/Angstrom
#density = gram/cm^dim

#[step, atom, value]
species=f['particles']['all']['species']['value'][()]
box=f['particles']['all']['box']['edges']['value'][()]

def trim(data, spe, key):
  data=np.swapaxes(data,0,1)
  #data=np.swapaxes(data,1,2)
  #3. make data contiguous
  #index used to be "timestep, "
  #pos, trj, atom
  return np.ascontiguousarray(data)

def getDeltaT(time):
  return (time[1]-time[0])  #in fetosecond

pos = f['particles']['all']['position']['value'][()]
post = trim(f['particles']['all']['position']['value'][()],species,1)

print(pos.shape)
print( pos[0,0,:])
print( pos[0,1,:])
vacf.test(pos,6)
print('\n')
print(post.shape)
print( post[0,0,:])
print( post[0,1,:])
vacf.test(post,6)
f.close()
