#!/usr/bin/python

from __future__ import print_function
import h5py
import numpy as np
import matplotlib.pyplot as plt

# (1000, 3333)

f=h5py.File('grt.h5','r')
grt=f['grt'][()]
rSpacingInAa=f['rSpacingInAa'][()]
tSpacingInfs=f['tSpacingInfs'][()]
f.close()

qrange = np.arange(grt.shape[0]//2) / rSpacingInAa
fqt= np.abs(np.fft.rfft(grt,axis=0)) # should not abs
print ('grt shape ', grt.shape)

plt.semilogx(grt[1], label = '1')
plt.semilogx(grt[20], label = '2')
plt.semilogx(grt[30], label = '3')
plt.legend()
plt.title('Gr')

plt.figure()

plt.semilogx(fqt[1], label = '1')
plt.semilogx(fqt[fqt.shape[0]//4], label = str(fqt.shape[0]//4))
plt.semilogx(fqt[fqt.shape[0]//2], label = str(fqt.shape[0]//2))
plt.legend()
plt.title('Ft')


plt.figure()
sqw = np.abs(np.fft.rfft(fqt, axis=1))


plt.imshow(np.log(sqw))

plt.title('Sw')







plt.show()
