#!/usr/bin/python
#to do.
#1. make ungarded fill inline
#2. make normal fill
from __future__ import print_function
import vacf
import time
import sys
import h5py
import numpy as np

fname = 'dump_h5md.h5'
if len(sys.argv)==2:
    fname = sys.argv[1]

f=h5py.File(fname,'r')

#For style real, these are the units:
#mass = grams/mole
#distance = Angstroms
#time = femtoseconds
#energy = Kcal/mole
#velocity = Angstroms/femtosecond
#force = Kcal/mole-Angstrom
#torque = Kcal/mole
#temperature = Kelvin
#pressure = atmospheres
#dynamic viscosity = Poise
#charge = multiple of electron charge (1.0 is a proton)
#dipole = charge*Angstroms
#electric field = volts/Angstrom
#density = gram/cm^dim

#[step, atom, value]
species=f['particles']['all']['species']['value'][()]

def trim(data, spe, key):
  old_shape = data.shape
  data=data[spe==key,:]
  atomLeft = data.shape[0]/old_shape[0]
  #1. get the corret shape
  data=data.reshape([old_shape[0], atomLeft, 3])
  #2. swap axes from [stepID, atomID, vector3] to [atomID, stepID, vector3]
  data=np.swapaxes(data,0,1)
  #3. make data contiguous
  #index used to be "timestep, "
  #pos, trj, atom
  return np.ascontiguousarray(data)

def getDeltaT(time):
  return (time[1]-time[0])  #in fetosecond

pos = trim(f['particles']['all']['position']['value'][()],species,1)
vel= trim(f['particles']['all']['velocity']['value'][()] ,species,1)
deltaTfs = getDeltaT(f['particles']['all']['species']['time'][()]) #in fs
box=f['particles']['all']['box']['edges']['value'][()]
print ('box size', box.shape)
f.close()

nStep= pos.shape[1]
nAtom = pos.shape[0]

#1 rad/sec = 6.5821e-16 eV
radpsec2meV =  6.5821e-13 * 2*np.pi
radpps2meV =  radpsec2meV*1e12
radpfs2meV =  radpsec2meV*1e15

print ('Delta time ',deltaTfs,'fs')
print ('Velocity size after trim ', vel.shape)



#####c
start_time = time.time()

numSpatialBin= 1000
wlCut = 15.
numTimeBin = nStep/10
gtr = np.zeros([numTimeBin, numSpatialBin ], dtype = np.float64)

vacf.grt_vec(pos, pos.size,
             box, box.size,
             gtr, gtr.size,
             numSpatialBin, wlCut,
             deltaTfs, nAtom,  nStep)
print  ('c function elapsed ' , time.time() - start_time, 's')

rSpacingInAa = wlCut/numSpatialBin
tSpacingInfs = deltaTfs


f=h5py.File('grt.h5','w')
f['grt'] = np.ascontiguousarray(np.swapaxes(gtr,0,1))
f['rSpacingInAa'] = rSpacingInAa
f['tSpacingInfs'] = tSpacingInfs
f.close()

# fqt=np.fft.rfft(grt,axis=0)
# sqw=np.fft.rfft(fqt.real,axis=1)
#
# rSpaceResl = wlCut/numSpatialBin
# kSpaceResl = 1./rSpaceResl
# qaxis = np.arange(numSpatialBin) * kSpaceResl # in Aa^-1
# taxis = np.arange(numTimeBin) * deltaTfs #in fs
# eaxis = np.arange(numTimeBin)/deltaTfs * radpfs2meV
# sqw=np.abs(np.fft.fft2(grt))
#
# plt.contour( eaxis,qaxis, sqw)
