#include <string>
#include "RedisIO.hh"
#include "StateMachine.hh"

class RunStatus : public StateMachine {
public:


public:
	RunStatus(const std::shared_ptr<RedisIO> &r, const std::string &cmdpath, const std::string &hbpath );
	virtual ~RunStatus();

  Command update();
	std::string genHeartBeat() const;
  void sendHeartBeat() const;
	std::string genHeartBeat(RunStatus::State s) const;
	void sendHeartBeat(RunStatus::State s) const;


private:
  std::shared_ptr<RedisIO> m_redis;
  const std::string m_cmdPath, m_heartBeatPath;
  unsigned m_proID;

};
