#include "RunStatus.hh"
#include <unistd.h>  //getpid
#include <nlohmann/json.hpp>
#include "Earthworm.hh"
#include <ctime>

RunStatus::RunStatus(const std::shared_ptr<RedisIO> &r,
const std::string &cmdpath, const std::string &hbpath )
:StateMachine(1), m_redis(std::shared_ptr<RedisIO>(r))
,m_cmdPath(cmdpath), m_heartBeatPath(hbpath)
,m_proID(getpid())
{

}

RunStatus::~RunStatus()
{

}

RunStatus::Command RunStatus::update()
{
  int cmdint = atoi(m_redis->readString(m_cmdPath).c_str());
  auto oldstate = m_state.load();
  if(cmdint>=0 && cmdint<kNumCommand)
  {

    if(transit(cmdint)!=oldstate)
    {
      EW_LOG_INFO("Command {} changed state {} to {}", cmdint, kStateStrMap.find(oldstate)->second, printState());
      return int2cmd(cmdint);
    }

  }
  // EW_LOG_INFO("Command {} for old state {} is ineffective", cmdint, kStateStrMap.find(oldstate)->second);
  return Command::kIneffective;
}

std::string RunStatus::genHeartBeat() const
{
  return RunStatus::genHeartBeat(m_state);
}

std::string RunStatus::genHeartBeat(RunStatus::State s) const
{
  nlohmann::json j;
  j["pid"] = m_proID;
  j["status"] = printState(s);

  std::time_t t = std::time(nullptr);
  char mbstr[100];
  if (std::strftime(mbstr, sizeof(mbstr), "%Y-%m-%dT%H:%M:%S.%03d+08:00", std::localtime(&t))) {
  }

  j["timestamp"] = std::string (mbstr);
  return j.dump();
}

void RunStatus::sendHeartBeat(RunStatus::State s) const
{
  m_redis->writeString(m_heartBeatPath,genHeartBeat(s));
}

void RunStatus::sendHeartBeat() const
{
  RunStatus::sendHeartBeat(m_state);
}
