
#include <dic.hxx>
#include <iostream>
#include <vector>
#include <string>
#include <fstream>
#include <memory>
#include <chrono>
#include <future>
#include <nlohmann/json.hpp>
#include <unistd.h>  //getpid

#include "Action_MR.hh"
#include "Earthworm.hh"


Action_MR::Action_MR(RedisIO *redis,std::shared_ptr<Hist2DMap> histmap,
	 MyStateMachine *sMachine)
: Action(redis),  m_detType(Hist2DMap::DetectorType::kUnknown),
  m_histmap( histmap),
	m_sMachine(sMachine),
	m_daq_he3(nullptr), m_daq_mwpc(nullptr) , m_active_daq(nullptr)
{
  std::ifstream f("../allPath.json");
  m_allPath.clear();
  f >> m_allPath;
  f.close();

  m_daq_he3 =	new DAQInterface(m_allPath["dimserverHe3"],1000);
	m_daq_mwpc =	new DAQInterface(m_allPath["dimserverMWPC"],1000);
}

Action_MR::~Action_MR()
{
	EW_LOG_INFO("~Action_MR::  " );
	delete m_daq_he3;
  delete m_daq_mwpc;
}

bool Action_MR::configure()
{
	//fixme: he3 only
	//fixme: update m_allPath fisrt !!!!!

	std::ifstream f("../allPath.json");
	m_allPath.clear();
	f >> m_allPath;
  f.close();

	std::string conf = m_redis->readString(m_allPath["configure"]);//
	auto confjson =	nlohmann::json::parse(conf);

	std::string dt= confjson["mode"];
	if(dt=="He3")
	{
		m_active_daq = m_daq_he3;
		m_daq_he3->setHist2DMap(m_histmap);
		m_detType=Hist2DMap::DetectorType::kHe3;
	 }
	else if(dt=="MWPC")
	{
		m_active_daq = m_daq_mwpc;
    m_detType=Hist2DMap::DetectorType::kMWPC;
	}

	m_histmap->reset();

	if(m_histmap)
	{
		EW_LOG_INFO("configure:: histmap is valid " );
	}
	else
	  EW_LOG_CRITICAL("configure:: NULL histmap");

	unsigned pid_num(300), tof_num(2500);

	std::vector<double> pid;
	for(unsigned i=0;i<pid_num*4;i++)
	  pid.push_back(i+1);
	RedisNumpy nvt;
  std::string pidstr;
	std::vector<uint64_t> shape;
	shape.push_back(pid_num*4);
	nvt.makeNumpyArr(pid, RedisNumpy::data_type::f8,
									 shape, pidstr);
	m_redis->writeString(m_allPath["rawDataPixel"], pidstr);

	std::vector<double> tof;
	for(unsigned i=0;i<tof_num+1;i++)
	{
		tof.push_back(i*16);
	}
	std::string tofstr;
	shape[0]=(tof_num+1);
	nvt.makeNumpyArr(tof, RedisNumpy::data_type::f8,
									 shape, tofstr);
	m_redis->writeString(m_allPath["rawDataTof"], tofstr);


	EW_LOG_INFO("configure:: Configuration completed. Instrument active detector is {}.", dt);
	return true;
}

//Stop running and clear any runtime determined parameter
bool Action_MR::unconfigure()
{
	m_active_daq->setActive(false);
	m_active_daq = nullptr;
	m_detType = Hist2DMap::DetectorType::kUnknown;
	EW_LOG_INFO("unconfigure:: Earthworm unconfigured.");
	return true;
}

//Start accumulate data, RESET AGAIN HERE
bool Action_MR::start()
{
	EW_LOG_INFO("start:: Run started.");
	EW_LOG_CRITICAL("start:: Run is really started.");

	if(m_histmap)
	{
		EW_LOG_INFO("start:: histmap is valid in start" );
	}
	else
		EW_LOG_CRITICAL("start:: NULL histmap in start");

	EW_LOG_INFO("start:: Run started.");

	m_histmap->reset();
	m_active_daq->setActive(false);

	EW_LOG_INFO("start:: Reset buffer.");

	m_active_daq->setActive(true);

	m_startTime = std::chrono::steady_clock::now();
	return true;
}

//Paused fill histogram, still receive but unprocess dim datastream
bool Action_MR::pauseStop()
{
	m_active_daq->setActive(false);
	EW_LOG_INFO("pauseStop:: kPause or kStop.");
	return true;
}

bool Action_MR::abort()
{
	m_active_daq->setActive(false);
	EW_LOG_INFO("abort:: aborting");
	return true;
}

//Restart running
bool Action_MR::resume()
{
	m_active_daq->setActive(true);
	EW_LOG_INFO("resume:: kResume.");
	return true;
}

bool Action_MR::kill()
{
	if(m_active_daq)
		m_active_daq->setActive(false);
	m_kill=true;
	return true;
}


void Action_MR::sendHeartbeat(bool stateAsStr)
{
  nlohmann::json j;
  j["pid"] = getpid();
	if(stateAsStr)
	  j["status"] = m_sMachine->printState();
  else
		j["status"] = m_sMachine->getState();

  std::time_t t = std::time(nullptr);
  char mbstr[100];
  if (std::strftime(mbstr, sizeof(mbstr), "%Y-%m-%dT%H:%M:%S.%03d+08:00", std::localtime(&t))) {
  }

  j["timestamp"] = std::string (mbstr);
  std::string hb= j.dump();
	std::cout << "Heartbeart " << hb  << '\n';

  m_redis->writeString(m_allPath["hbEarthworm"],hb);
}

bool Action_MR::update()
{
	std::string str = m_redis->readString(m_allPath["ctrlEarthworm"]);
  return m_sMachine->transit(atoi(str.c_str()));
}

bool Action_MR::keepRunning()
{
	EW_LOG_INFO("keepRunning:: Keep running");

	// if(!m_active_daq->getHist2DMap())
	// {
	// 	m_active_daq->setHist2DMap(m_histmap);
	// }
	// else
	// {
	// 	EW_LOG_WARN("keepRunning:: setting hist again in keepRunning");
	// 	std::cout << "hist pointer is  " <<  m_histmap.get() << '\n';
	// }

	std::string redisDataStr;
	m_histmap->makeNumpyRaw(redisDataStr);
	m_redis->writeString(m_allPath["rawDataHist"], redisDataStr);
	double totcnt = m_histmap->getIntegral();
	double cnt_rate=0.;
	if(totcnt)
		cnt_rate=totcnt/std::chrono::duration_cast<std::chrono::milliseconds>(std::chrono::steady_clock::now() - m_startTime).count()*1000;
	if(totcnt)
		EW_LOG_INFO("keepRunning:: Data integral {}, rate is {} event/s", totcnt,
							cnt_rate);
	else
		EW_LOG_INFO("keepRunning:: Data integral is 0");

	if( m_detType==Hist2DMap::DetectorType::kHe3)
	{
			m_redis->writeString(m_allPath["he3DetCnt"], std::to_string((int) m_histmap->getIntegral()) );
			m_redis->writeString(m_allPath["he3DetCntRate"], std::to_string(cnt_rate) );
	}
	else if( m_detType==Hist2DMap::DetectorType::kMWPC)
	{
			m_redis->writeString(m_allPath["mwpcDetCnt"],std::to_string((int) m_histmap->getIntegral())+"}");
  }
	else
		EW_LOG_CRITICAL("keepRunning:: Detector type is unconfigured!");

	return true;
}
