#ifndef DimRecv_DAQInterface_hh
#define DimRecv_DAQInterface_hh

// DimClient class
//Inform the Server that this client would like the Server to execute an ExitHandler when it dies.
// static setExitHandler ( char * serverName) ;
// Instruct the Server to execute the virtual method errorHandler whenever the DIM server sees an error.
// If no errorHandler is declared the DIM server prints an error message.
// static addErrorHandler (DimErrorHandler *handler ) ;


#include <dic.hxx>
#include "UtilsException.hh"
#include <iostream>
#include <string>
#include <future>
#include <mutex>
#include <vector>
#include <chrono>
#include <utility>      // std::pair
#include <memory>

#include "DaqTask.hh"
class Hist2DMap;

class ErrorHandler : public DimErrorHandler
{
	void errorHandler(int severity, int code, char *msg)
	{
		int index = 0;
		char **services;
		if(code)
    {

    }
		std::cout << severity << " " << msg << std::endl;
		services = DimClient::getServerServices();
		std::cout<< "from "<< DimClient::getServerName() << " services:" << std::endl;
		while(services[index])
		{
			std::cout << services[index] << std::endl;
			index++;
		}
	}
public:
	ErrorHandler() {DimClient::addErrorHandler(this);}
};


//This is the base class for decoding detector raw data.
class DAQInterface: public DimClient {
public:
	struct DataFlow {
		int64_t num_dim_trigger, completed_task;
		int64_t received_byte, processed_byte, processed_event;
		double event_rate;
	};
public:
  DAQInterface(std::string daq_name="DAQ",
               unsigned houseKeeping_itervl_ms = 1000);
  virtual ~DAQInterface();
	//infoHandler treat newly received data
  void infoHandler() override;
	void setActive(bool act) ;
	void setHist2DMap(const std::shared_ptr<Hist2DMap>& map);
	const std::shared_ptr<Hist2DMap>& getHist2DMap() const;
	void report();

private:
	//remove finished calculation in m_tasks to release resources,
	//based on the Erase–remove idiom.
	void houseKeeping();

  std::atomic<bool> m_active_dim, m_terminate;
	// bool m_active_dim, m_terminate;
	//dim
  ErrorHandler m_errhdl;
  DimStampedInfo m_daq_data;

  // task and info
  std::vector<DaqTask> m_tasks;
  DataFlow m_flow;

	// house keeping
  std::mutex m_task_mutex;
  std::chrono::milliseconds m_houskpg_intvl_ms;
	std::chrono::system_clock::time_point m_start_time;
  // std::thread m_hk_thread;
	std::shared_future<void> m_hk_future;

	//histogram
	std::shared_ptr<Hist2DMap> m_hist_map; //fixeme: map searching could be slow

};

#endif
