#!/usr/bin/python

from __future__ import print_function
import vacf
import time
import sys
import h5py
import numpy as np
import matplotlib.pyplot as plt
from xlib import *

fname = 'dump_h5md.h5'
if len(sys.argv)==2:
    fname = sys.argv[1]

trj = Trajectory(fname)
print ('getAtomType', trj.getAtomType())


# timeStep = np.unique(np.logspace(0,3,200,dtype=np.uint32))
timeStep=np.arange(0,100,20,dtype=np.uint32)
Q=np.array([0.1, 1.6, 3])

start_time = time.time()
#ftq_hh=trj.incoInter( 1,  Q, timeStep)
ftq_hh=trj.intermediate( 1, 1,  Q, timeStep)

print  ('time ' , time.time() - start_time, 's')

f=h5py.File('ftq_hh.h5','w')
f['ftq_hh']=ftq_hh
f.close()


for res, aq in zip(ftq_hh.T, Q):
    plt.semilogx(timeStep*trj.getDeltaT()*1e-3, res, 'o', label='Q='+str(aq))

# print(FsTQ)
dataabe=np.loadtxt('abe2015fig1.dat')
plt.semilogx(dataabe[:,0],dataabe[:,1], zorder=100, label='Q=1.6A^-1')

plt.legend()
plt.xlabel('time, ps')
plt.ylabel('Fs(Q,t)')

plt.figure()
sswq = []
for aftq in ftq_hh.T:
    sswq.append( trj.axis0fft(aftq))
sswq=np.asarray(sswq)

plt.semilogy(sswq[0,:])
plt.semilogy(sswq[1,:])
plt.semilogy(sswq[2,:])

plt.show()
