#include "parseXML.h"
#include <boost/algorithm/string/classification.hpp>
#include <boost/algorithm/string/split.hpp>
#include <typeinfo>
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <typeinfo>

using namespace std;

string ParseXML::getStringValue(string name, TiXmlElement *node)
{
    TiXmlElement *search=root->FirstChildElement();
    TiXmlNode *tmp;
    getNode(node, search, name.c_str());
    if(0==strcmp(name.c_str(), search->Value()))
    {
        tmp=search->FirstChild();
        if (tmp==NULL)
        {
            return "None";
        }else{
            //cout<<"tmp: "<<tmp->Value()<<" name is "<<name<<endl;
            return tmp->ToText()->Value();}
    }else{
        return "None";
    }
}

float ParseXML::getNumValue(string name, TiXmlElement *node)
{
    TiXmlElement *search=root->FirstChildElement();
    TiXmlNode *tmp;
    getNode(node, search, name.c_str());
    //cout<<"get ========= "<<search->Value()<<endl;
    if(0==strcmp(name.c_str(), search->Value()))
    {
        tmp=search->FirstChild();
        if (tmp==NULL)
        {
            //cout<<"none!!!!"<<endl;
            return 0.0;
        }else{
            //cout<<"return tmp: "<<atof(tmp->ToText()->Value())<<" name is "<<name<<endl;
            return atof(tmp->ToText()->Value());}
    }else{return 0.0;}
}

vector<float> ParseXML::getArrayValue(string name, TiXmlElement *node, int num)
{
    vector<string> tmp;
    vector<float> data;
    TiXmlElement *search;
    TiXmlNode *son;
    const char* str;
    //cout<<node->Value()<<" ; "<<name<<endl;
    if(getNode(node, search, name.c_str()))
    {
        son=search->FirstChild();
        //cout<<son->Value()<<endl;    
        if (son==NULL)
        {
            for(int i =0; i!=num; i++)
                data.push_back(0.0);

        }else{
            str=son->ToText()->Value();
            boost::split(tmp,str,boost::is_any_of(" "), boost::token_compress_on);
            for(int i =0; i!=num; i++)
                data.push_back(atof(tmp[i].c_str()));
            tmp.clear();
        }
    }else{
        for(int i =0; i!=num; i++)
            data.push_back(0.0);
    }
    return data;
}

bool ParseXML::getNode(TiXmlElement *tree, TiXmlElement * &destNode, const char* nodeName)
{
    if(0==strcmp(nodeName, tree->Value()))
    {
        //cout<<"tree is "<<tree->Value()<<endl;
        destNode=tree;
        return true;
    }
    TiXmlElement *pNode=tree;
    for(pNode=pNode->FirstChildElement();pNode!=NULL;pNode=pNode->NextSiblingElement()){
        //cout<<"FirstChildElement is "<<pNode->Value()<<endl;
        if(0==strcmp(nodeName,pNode->Value()))
        {
            //cout<<"FirstChildElement == nodeName "<<pNode->Value()<<endl;
            destNode=pNode;
            return true;
        }else{
            getNode(pNode, destNode,nodeName);}
    }
    return false;
}

bool ParseXML::getNode(TiXmlElement *tree, TiXmlElement * &destNode, const char* nodeName, const char* attrName, const char* attrValue)
{
    TiXmlAttribute *attr;
    if(0==strcmp(nodeName, tree->Value()))
    {
        for(attr=tree->FirstAttribute();attr!=NULL; attr=attr->Next())
        {
            if((0==strcmp(attr->Name(), attrName)) && (0==strcmp(attr->Value(),attrValue)))
            {
                destNode=tree;
                return true;
            }
        }
    }
    TiXmlElement *pNode=tree;
    for(pNode=pNode->FirstChildElement();pNode!=NULL;pNode=pNode->NextSiblingElement())
    {
        if(0==strcmp(nodeName,pNode->Value()))
        {
            for(attr=pNode->FirstAttribute();attr!=NULL; attr=attr->Next())
            {
                //cout<<"attr is "<<pNode->Value()<<":"<<attr->Value()<<endl;
                if((0==strcmp(attr->Name(), attrName)) && (0==strcmp(attr->Value(),attrValue))){
                    destNode=pNode;
                    return true;
                }
            }
        }else
            getNode(pNode,destNode,nodeName,attrName,attrValue);
    }    
    return false;
}


map<string, float> ParseXML::getTofInfo()
{
    map<string, float> data;
    TiXmlElement *search=root->FirstChildElement();
    TiXmlAttribute *attr;
    getNode(root, search, "tofInformation");
    if(0==strcmp(search->Value(), "tofInformation"))
    {
        for(attr=search->FirstAttribute(); attr!=search->LastAttribute();attr=attr->Next()){
            if(0==strcmp(attr->Name(),"tofstep"))
                data.insert(make_pair("tofstep", atof(attr->Value())));
            if(0==strcmp(attr->Name(),"tofstart"))
                data.insert(make_pair("tofstart", atof(attr->Value())));
            if(0==strcmp(attr->Name(),"tofbin"))
                data.insert(make_pair("tofbin", atof(attr->Value())));
        }
    }
    return data;     
}


CSNSgeometry ParseXML::getGeometry(TiXmlElement *node)
{
    CSNSgeometry data;
    //vector<string> tmp;
    vector<float> tmp;
    TiXmlElement *search=root->FirstChildElement();
    TiXmlElement *group;
    TiXmlText *text;
    const char* str;
    int num=2;
    cout<<"get Geometry"<<endl;
    getNode(node, group, "NXgeometry");
    { 
        getNode(group, search, "NXshape");
        if(0==strcmp(search->Value(), "NXshape"))
        {
            data.shape=getStringValue("shape", search);
            //cout<<data.shape<<endl;
            if (0==strcmp("nxcylinder", data.shape.c_str()))
            { num = 2 ;
            }else{
                num =3;
            } 
            tmp=getArrayValue("size", search, num);
            for (int i =0; i!=3; i++)
                data.size[i]=tmp[i];
            tmp.clear();
        }else{
            for (int i =0; i!=3; i++)
                data.size[i]=0.0;}
        if(getNode(search, group, "NXorientation"))
        {
            tmp=getArrayValue("value", search, 6);
            //cout<<tmp.size()<<endl;
            for (int i =0; i!=6; i++)
                data.ori[i]=tmp[i];
            tmp.clear();
        }else{
            for (int i =0; i!=6; i++)
                data.ori[i]=0.0;
        }
        if(getNode(search, group, "NXtranslation"))
        {
            tmp=getArrayValue("distances", search, 3);
            for (int i =0; i!=3; i++)
                data.distances[i]=tmp[i];
            tmp.clear();
        }else{
            for (int i =0; i!=3; i++)
                data.distances[i]=0.0;

        }
    }
    return data;
}


map<string, string> ParseXML::getPublic()
{
    std::map<string, string> data;
    TiXmlElement *search, *node;
    TiXmlText *text;
    const char* str;
    const char* str2;
    node=root->FirstChildElement();
    //cout<<"get pub: "<<node<<endl;
    for(search=node->FirstChildElement();search!=NULL; search=search->NextSiblingElement()){
        TiXmlNode *tmp=search->FirstChild();

        if(tmp && tmp->Type()==TiXmlNode::TINYXML_TEXT){
            text=search->FirstChild()->ToText();
            str=search->Value();
            str2=text->Value();
            //cout<<"get pub attri : "<<str<<endl;
            data.insert(make_pair(str, str2));
        }else
            continue;
    }
    return data;
}

CSNSsample ParseXML::getSample()
{
    CSNSsample data;
    TiXmlElement *search, *node;
    TiXmlText *text;
    TiXmlNode *tmp;
    getNode(root,search, "NXsample");
    if(0==strcmp("NXsample", search->Value()))
    {
        //cout<<"name: "<<search->Value()<<endl;
        data.chemical_formula=getStringValue("chemical_formula",search);
        data.name=getStringValue("name",search);
        //cout<<data.name<<endl;
        data.situation=getStringValue("situation",search);
        data.type=getStringValue("type",search);
        data.distance=getNumValue("distance",search);
        data.density=getNumValue("density",search);
        //cout<<data.density<<endl;
        data.mass=getNumValue("mass",search);
        data.geometry=getGeometry(search);
        cout<<"finish getSample!!!"<<endl;
    }
    return data;
}

vector<CSNSse> ParseXML::getSE()
{
    std::vector<CSNSse> data;
    TiXmlElement *search=root->FirstChildElement();
    TiXmlText *text;
    TiXmlAttribute *attr;
    getNode(root, search, "NXenvironment");
    if (0==strcmp(search->Value(), "NXenvironment"))
    {
        for(;search!=NULL; search=search->NextSiblingElement()){
            if (0==strcmp(search->Value(), "NXenvironment"))
            {
                attr=search->FirstAttribute();
                CSNSse tmp;
                if(attr==NULL)
                {
                    tmp.seName="SE";
                }else{
                    tmp.seName=attr->Value();}

                tmp.name=getStringValue("name", search);
                //tmp.type=getStringValue("type", search);
                //tmp.temperature=getNumValue("temperature", search);
                //tmp.pressure=getNumValue("pressure", search);
                //tmp.magnetic_field=getNumValue("magnetic_field", search);
                //tmp.electric_field=getNumValue("electric_field", search);
                //tmp.t2=getNumValue("t2", search);
                data.push_back(tmp);
            }
        }
    }else{cout<<"can't find se"<<endl;}
    return data;
}

vector<CSNSdc> ParseXML::getDC()
{
        std::vector<CSNSdc> data;
        TiXmlElement *search;
        TiXmlText *text;
        TiXmlAttribute *attr;
        getNode(root, search, "NXdisk_chopper");
        //cout<<"getNode=="<<search->Value()<<endl;
        if(0==strcmp(search->Value(),"NXdisk_chopper"))
        {
            for(search; search!=NULL; search=search->NextSiblingElement())
            {
                if(0==strcmp(search->Value(),"NXdisk_chopper"))
                {CSNSdc tmp;
                    attr=search->FirstAttribute();
                    tmp.dcName=attr->Value();
                    //cout<<"dc info111: "<<tmp.dcName<<endl;
                    tmp.phase=getNumValue("phase", search);
                    tmp.slitAngle=getNumValue("slit_angle", search);
                    tmp.rotationSpeed=getNumValue("rotation_speed", search);
                    tmp.distance=getNumValue("distance", search);
                    //cout<<"dc info:phase "<<tmp.phase<<endl;
                    data.push_back(tmp);
                }}
        }else{cout<<"can't fine dc"<<endl;}
        cout<<"finish get DC"<<endl;
        return data;
    }

    CSNSsource ParseXML::getSource()
    {
        CSNSsource data;
        TiXmlElement *search, *node;
        TiXmlText *text;
        getNode(root,search,"NXsource"); 
        //cout<<"NXsource: "<<search->Value()<<endl;    

        data.name=getStringValue("name", search);
        data.type=getStringValue("type", search);
        data.probe=getStringValue("probe", search);
        data.frequency=getNumValue("frequency", search);
        data.power=getNumValue("power", search);

        return data;
    }
    CSNSmoderator ParseXML::getModerator()
    {
        CSNSmoderator data;
        TiXmlElement *search, *node;
        TiXmlText *text;
        getNode(root, search, "NXmoderator"); 

        data.type=getStringValue("type", search);
        data.temperature=getNumValue("temperature", search);
        data.distance=getNumValue("distance", search);

        return data;
    }

    vector<CSNSaperture> ParseXML::getAperture()
    {
        vector<CSNSaperture> data;
        CSNSaperture tmp;
        TiXmlElement *search=root->FirstChildElement();
        TiXmlAttribute *attr;
        getNode(root,search, "NXaperture");
        for(search; search!=NULL; search=search->NextSiblingElement())
        {
            if(0==strcmp("NXaperture",search->Value()))
            {
                CSNSaperture tmp;
                attr=search->FirstAttribute();
                tmp.apertureName=attr->Value();
                tmp.xgap=getNumValue("x_gap", search);
                tmp.ygap=getNumValue("y_gap", search);
                data.push_back(tmp);
            }
        }
        return data;
    }

    vector<CSNSslit> ParseXML::getSlit()
    {
        vector<CSNSslit> data;
        CSNSslit tmp;
        TiXmlElement *search=root->FirstChildElement();
        TiXmlAttribute *attr;
        getNode(root,search, "NXSlit");
        for(search; search!=NULL; search=search->NextSiblingElement())
        {
            if(0==strcmp("NXSlit",search->Value()))
            {
                CSNSslit tmp;
                attr=search->FirstAttribute();
                tmp.slitName=attr->Value();
                tmp.xgap=getNumValue("x_gap", search);
                tmp.ygap=getNumValue("y_gap", search);
                data.push_back(tmp);
            }
        }
        return data;
    }

    CSNSdet ParseXML::getDetector(bool bm)
    {
        CSNSdet data;
        TiXmlElement *search, *psearch;
        TiXmlText *text;
        TiXmlAttribute *attr;

        const char* str;
        if(bm)
        {
            getNode(root,search, "NXdetector");
            if(0==strcmp("NXdetector",search->Value()))
            {
                attr=search->FirstAttribute();
                data.name=attr->Value();
                data.local_name=getStringValue("local_name", search);
                data.delay=getNumValue("delay",search); 
                data.distance=getNumValue("distance",search); 
                data.rotate_angle=getNumValue("rotate_angle",search);
                data.mode=getStringValue("detector_mode",search); 
            }
        }else{
            getNode(root,search, "NXmonitor");
            if(0==strcmp("NXmonitor",search->Value()))
            {
                attr=search->FirstAttribute();
                data.name=attr->Value();
                data.local_name=getStringValue("local_name", search);
                data.delay=getNumValue("delay",search); 
            }
        }
        return data;
    }

    /*
       CSNSbs ParseXML::getBS()
       {
       CSNSbs data;
       TiXmlElement *search, *node;
       getNode(root, search, "NXbeam_stop");
       data.geometry=getGeometry(search);
       getDistance(search, data.distance);
       TiXmlText *text;
       getNode(search, node, "status");
       text=node->FirstChild()->ToText();
       data.status=text->Value();
       return data;
       }
       */

    vector<CSNSlogs> ParseXML::getLogs()
    {
        vector<CSNSlogs> data;
        TiXmlElement *search, *node, *group;
        TiXmlText *text;
        const char* str2;
        getNode(root, search, "NXcollection");
        cout<<"search:"<<search->Value()<<endl;
        for(node=search->FirstChildElement(); node!=NULL; node=node->NextSiblingElement())
        {
            CSNSlogs tmp;
            tmp.name = node->Value();
            text=node->FirstChild()->ToText();
            str2=text->Value();
            boost::split(tmp.filePath,str2,boost::is_any_of(":"), boost::token_compress_on);
            data.push_back(tmp);
        }

        /*
           getNode(search, node, "proton_charge");
           text=node->FirstChild()->ToText();
           str2=text->Value();
           boost::split(data.proton_charge,str2,boost::is_any_of(":"), boost::token_compress_on);

           getNode(search, node, "disk_chopper_phase1");
           text=node->FirstChild()->ToText();
           str2=text->Value();
           boost::split(data.disk_chopper_phase1,str2,boost::is_any_of(":"), boost::token_compress_on);

           getNode(search, node, "sample_electric_field");
           text=node->FirstChild()->ToText();
           str2=text->Value();
           boost::split(data.sample_electric,str2,boost::is_any_of(":"), boost::token_compress_on);

           getNode(search,node, "sample_magnetic_field");
           text=node->FirstChild()->ToText();
           str2=text->Value();
           boost::split(data.sample_magnetic, str2,boost::is_any_of(":"), boost::token_compress_on);

           getNode(search,node, "sample_pressure");
           text=node->FirstChild()->ToText();
           str2=text->Value();
           boost::split(data.sample_pressure,str2,boost::is_any_of(":"), boost::token_compress_on);

           getNode(search, node, "sample_environment_temperature");
           text=node->FirstChild()->ToText();
           str2=text->Value();
           boost::split(data.sample_temperature,str2,boost::is_any_of(":"), boost::token_compress_on);
           */
        return data;
    }

    map<string, float> ParseXML::getModuleInfo(const char* moduleName)
    {
        map<string, float> data;
        TiXmlElement *search, *psearch;
        TiXmlNode *node;
        TiXmlAttribute *attr;
        getNode(root, search, "location", "name", moduleName);
        for(attr=search->FirstAttribute();attr!=NULL;attr=attr->Next())
        {
            data.insert(make_pair(attr->Name(),atof(attr->Value()))); 
        }
        node=search;
        node=node->Parent();
        psearch=node->ToElement();
        for(attr=psearch->FirstAttribute();attr!=NULL; attr=attr->Next())
        {
            if(0==strcmp("idstart",attr->Name())||
                    0==strcmp("idstepbyrow",attr->Name()))
                data.insert(make_pair(attr->Name(),atof(attr->Value())));
            //cout<<"idstart:"<<data["idstart"]<<endl;

        }
        getNode(psearch, search, "rot");
        for(attr=search->FirstAttribute();attr!=NULL; attr=attr->Next())
            data.insert(make_pair(attr->Name(),atof(attr->Value())));

        getNode(root, search, "type", "name", "panel");
        for(attr=search->FirstAttribute();attr!=NULL; attr=attr->Next())
        {
            if(0==strcmp("xpixels",attr->Name())||
                    0==strcmp("ypixels",attr->Name())||
                    0==strcmp("xstart",attr->Name())||
                    0==strcmp("ystart",attr->Name())||
                    0==strcmp("xstep",attr->Name())||
                    0==strcmp("ystep",attr->Name()))
                data.insert(make_pair(attr->Name(),atof(attr->Value())));
        }
        return data;
    }

    map<string, float> ParseXML::getMonitorInfo(const char* idName)
    {
        map<string, float> data;
        TiXmlElement *search, *psearch;
        TiXmlNode *node;
        TiXmlAttribute *attr;
        getNode(root, search, "left-front-bottom-point");
        //cout<<search->Value()<<endl;
        for(attr=search->FirstAttribute();attr!=NULL;attr=attr->Next())
        {
            if(0==strcmp("x",attr->Name())){
                float x=-2*atof(attr->Value());
                data.insert(make_pair("xstep",x));
            }
            if(0==strcmp("y",attr->Name())){
                float y=-2*atof(attr->Value());
                data.insert(make_pair("ystep",y));
            }
        }
        //cout<<idName<<endl;
        //cout<<data["xstep"]<<endl;
        getNode(root, search, "idlist","idname",idName);
        psearch=search->FirstChildElement();
        // cout<<psearch->Value()<<endl;
        for(attr=psearch->FirstAttribute();attr!=NULL;attr=attr->Next())
        {
            if(0==strcmp("start",attr->Name()))
                data.insert(make_pair("idstart",atof(attr->Value())));
        }
        return data;

    }

    void ParseXML::getMonitorPos(float (*pos)[3], const char* monitorName)
    {
        TiXmlElement *search,*son; 
        TiXmlAttribute *attr;
        getNode(root, search, "component", "name", monitorName);
        int i=0;
        for(son=search->FirstChildElement();son!=NULL;son=son->NextSiblingElement())
        {
            for(attr=son->FirstAttribute();attr!=NULL; attr=attr->Next())
            {
                if(0==strcmp("x",attr->Name()))
                    pos[i][0]=atof(attr->Value());
                if(0==strcmp("y",attr->Name()))
                    pos[i][1]=atof(attr->Value());
                if(0==strcmp("z",attr->Name()))
                    pos[i][2]=atof(attr->Value());
            }
            i++;
        }
    }
