#ifndef IncPARSENXS
#define IncPARSENXS

#include <string>
#include <map>
#include <vector>
#include <list>
#include <tinyxml.h>
#include "nexus/NeXusFile.hpp"

using namespace std;
/*
struct evtMode{
    string name;
    uint64_t evtNum;
    int64_t* pid;
    float* tof;
    uint64_t* pulse;
};
struct histMode{
    string name;
    uint32_t **array ;
};
*/

class ParseNXS {
    public:
        ParseNXS(string filepath)
        { nxsfile = filepath;}
        void getEventData(string filename,uint64_t& evtNum, int64_t* pid, float* tof, uint64_t* pulse);  // now this is just for single module
        void getHistData(string prepath, string runno, string filename, uint32_t* histData, bool bm);
        void setPublic(ParseXML new_xml, string idfFilename); // from summary xml file
        void setUser(ParseXML new_xml); //set default value
        void setProcess(); // set default value
        void setPresentData(const int timeBin, const int timeStep); // set random value
        //void setHistData(string dName[], const int dSize); //set link for all module or monitor
        void setHistData(const int dSize, string dName[]); //set link for all module or monitor
        void setEventData(string dName[], const int dSize); //set link for all module or monitor
        void setLogs(ParseXML new_xml);//unfinished, no log file!
        //void setData(string name);
        void setInstrument(ParseXML new_xml);//include sample, SE, DC, source, moderator, apeture
        void setModerator(NXstatus status, NXhandle fileID, CSNSmoderator moderatorFromSummary);
        void setSource(NXstatus status, NXhandle fileID, CSNSsource sourceFromSummary);
        void setSample(NXstatus status, NXhandle fileID, CSNSsample sampleFromSummary);
        void setSE(NXstatus status, NXhandle fileID, vector<CSNSse> se);
        void setDC(NXstatus status, NXhandle fileID, vector<CSNSdc> diskChopper);
        void setAperture(NXstatus status, NXhandle fileID, vector<CSNSaperture> aperture);
        void setSlit(NXstatus status, NXhandle fileID, vector<CSNSslit> slit);
        //void setDetector(ParseXML sum_xml, ParseXML idf_xml, const string detName[],const int dSize, const int xpid, const int ypid, const int timeBin, const int timeStep);
        //void setDetector(string prepath, string runno, ParseXML sum_xml, ParseXML idf_xml, const int xpid, const int ypid, const int timeStart, const int timeBin, const int timeStep, const int dSize, string dName[], bool bm);
        void setDetector(string prepath, string runno, ParseXML sum_xml, ParseXML idf_xml, ParseXML conf_xml, const int dSize, string dName[], bool bm);
        void setPid(NXstatus status, NXhandle fileID, int idstart, const int xpid, const int ypid);
        void setTof(NXstatus status, NXhandle fileID,const int timeStart, const int timeBin, const int timeStep, const int delay);
        void setHist_module(NXstatus status, NXhandle fileID, uint64_t evtNum,const int64_t* pid, const float* tof, string detName, const int xpid, const int ypid, const int timeBin);
        void setPidSize(NXstatus status, NXhandle fileID, map<string, float> m_info, const int xpid, const int ypid);
        void setCoordinate_module(NXstatus status, NXhandle fileID, map<string, float> m_info, const int xpid, const int ypid);

    private:
        string nxsfile;
        void writeGroup(NXstatus status, NXhandle fileID, const char* groupName, const char* groupType);
        void writeCharData(NXstatus status, NXhandle fileID, const std::string dataName, const std::string dataValue);
        void writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const float* dataValue, int dimension, int dim[], std::string text);
        void writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const int64_t* dataValue, int dimension, int dim[], std::string text);
        void writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const uint64_t* dataValue, int dimension, int dim[], std::string text);
        void writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const uint32_t* dataValue, int dimension, int dim[], std::string text);
        void writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const float* dataValue, int dim[], int slab_start[], int slab_size[], std::string text);
        void writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const int64_t* dataValue, int dim[], int slab_start[], int slab_size[], std::string text);
        void writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const uint32_t* dataValue, int dim[], int slab_start[], int slab_size[], std::string text);
        

};

#endif
