#include "ParserBase.hh"
#include "UtilsException.hh"
#include "ctypes_api.hh"
#include <cstdio>
Parser::ParserBase::ParserBase()
{

}

Parser::ParserBase::~ParserBase()
{

}

void Parser::ParserBase::read_uint32_many(const uint8_t*& pos, std::vector<uint32_t> &u32_vec, unsigned num) const
{
  if(u32_vec.size()!=num)
    u32_vec.resize(num);

  for(unsigned i=0;i<num;i++) {
    read_uint32(pos, u32_vec[i]);
  }
}

bool Parser::ParserBase::blankData(const uint8_t* const pos, const uint8_t * const stream_end) const
{
  unsigned dsize = stream_end-pos > 112? 112:stream_end-pos;
  for(unsigned i=0;i<dsize;i++)
  {
    if(pos[i])
     return false;
  }
  return true;
}


bool Parser::ParserBase::findNextPackageStartEnd(const uint8_t * const stream_end, const uint8_t*& start, const uint8_t*& pkgend, uint64_t &offset) const
{
  //fixme: detect zero padding data
  if(start>=stream_end)
    return false;

  offset=0;
  for(;start!=stream_end;start++,offset++)
  {
    if(fixStartFindEnd(start,stream_end,pkgend))
    {
      // if(offset) //fixme: add to log
      //   printf("Found next package in the stream with offst %ld, start at %ld to the end of stream\n", offset, stream_end-start); //fixme : logge
      return true;
    }
  }
  return false;
}
