#include "PMTParser.hh"
#include <vector>

Parser::PMTParser::PMTParser():ParserBase(), m_reconst() {}

Parser::PMTParser::~PMTParser() {}

//find the end position of a package
//Function returns true if the end position of a valid package is found
bool Parser::PMTParser::fixStartFindEnd(const uint8_t* const fixedStart, const uint8_t* const stream_end, const uint8_t*& pkgend) const
{
  if(fixedStart>=stream_end)
    return false;

  if(*fixedStart!=0xFA)//start Token
    return false;

  for(uint8_t* pos= const_cast<uint8_t*>(fixedStart)+16; pos<stream_end; pos+=4)
  {
    //if(*pos<0xFB) //all good
    if(*pos==0xFB)
    {
      pkgend = pos + 8;
      return true;
    }
    else if(*pos>0xF0)
    {
      printf("Channel number greater than 0xF0");
      return false; //fixme: should raise error here
    }
  }
  return false;
}

uint64_t Parser::PMTParser::getPixelID(unsigned x, unsigned y)
{
	return uint64_t(100001+uint64_t(y/4.)*92+uint64_t(x/2.2));
}


//extract info from next package
bool Parser::PMTParser::extractNextPackage(const uint8_t*& pos, const uint8_t * const stream_end, std::vector<HitInfo>& hitinfo) const
{
  if(stream_end<=pos)
    return false;
  hitinfo.clear();
  const uint8_t *package_end;
  uint64_t offset=0;

  if(!findNextPackageStartEnd(stream_end, pos, package_end, offset))
    return false;

  // printf("full package \n");
  // for(auto it=pos;it!=package_end;++it)
  // {
  //   printf("0x%x ", *it);
  //   if((it-pos+1)%4==0 && it-pos>2)
  //     printf("\n");
  // }
  // printf("\n");
  // abort();

  uint32_t t0(0);
  pos += 8;
  read_uint32(pos, t0);

  //make hitmap of data
  std::vector<uint32_t> hitmap;
  for(pos+=4;pos<package_end-8;)
  {
    uint32_t data(0);
    read_uint32(pos, data);
    uint32_t tof  = MASK_24 & data;
    if(tof) //skip the padding zero
    {
      uint8_t chn= (data >> 24) & MASK_8;
      hitmap.push_back( (tof<<8) +chn);
    }
  }
  // no more reading after here, set pointer to the start of next package
  pos = package_end;

  std::sort(hitmap.begin(), hitmap.end());
  // m_reconst.execute(hitmap);
  // return true;

  //reconstruction
  int time=0;
  int timeleap=0;
  std::vector<uint32_t> chlBuf;
  for(uint32_t i = 0; i < hitmap.size(); i++)
  {
    if(0==i)
    {
      chlBuf.clear();
      chlBuf.push_back(hitmap[i]&MASK_8);
      time = (hitmap[i]>>8) & MASK_24;
    }
    else
    {
      timeleap = time - ((hitmap[i]>>8) & MASK_24);
      timeleap = abs(timeleap);
      if((80*MASK_8)>timeleap)
      {
        chlBuf.push_back(hitmap[i]&MASK_8);
      }
      else
      {
        reconstruct(chlBuf,hitinfo, time, t0);
        chlBuf.clear();
        chlBuf.push_back(hitmap[i]&MASK_8);
      }
      time = (hitmap[i]>>8) & MASK_24;
    }
  }
  // the last hit
  if(0<chlBuf.size()){
    reconstruct(chlBuf,hitinfo, time, t0);
  }

  return true;
}
