#ifndef PMTParser_hh
#define PMTParser_hh

#include "ParserBase.hh"
#include "GPPDSNDRecAlg.hh"
#include <algorithm>
#include <numeric>

namespace EXPORT_SYMBOL Parser {

class PMTParser : public ParserBase {
public:
  PMTParser();
  ~PMTParser() override;

  //find the end position of a package, invoked by findNextPackageStartEnd function in the base
  //Function returns true if the end position of a valid package is found
  bool fixStartFindEnd(const uint8_t* const fixedStart, const uint8_t* const stream_end, const uint8_t*& pkgend) const override ;

  //extract info from next package
  bool extractNextPackage(const uint8_t*& pos, const uint8_t * const stream_end, std::vector<HitInfo>& hitinfo) const override;

  inline void reconstruct(std::vector<uint32_t>& chlBuf, std::vector<HitInfo>& hitinfo, uint32_t tof, uint32_t t0) const;


  //this function is taken from DroNE GPPDSNDRecAlg.cc
  uint64_t getPixelID(unsigned x, unsigned y);

private:
  mutable GPPDSNDRecAlg m_reconst;
};

}


inline void Parser::PMTParser::reconstruct(std::vector<uint32_t>& chlBuf, std::vector<HitInfo>& hitinfo, uint32_t tof, uint32_t t0) const
{
  if(chlBuf.size()<2 || chlBuf.size()>20)
    return;

  std::sort(chlBuf.begin(), chlBuf.end());

  std::vector<int> x, y;
  for(auto it=chlBuf.begin();it!=chlBuf.end();++it)
  {
    auto val = *it;
    if(val<128)
    {
      if(!x.empty())
      {
        if(x.back()+1!=val && x.back()!=val)
          return;
      }
      x.push_back(val);
    }
    else {
      if(val>191)
        printf("WARNING Y greater than 191");

      if(!y.empty())
      {
        if(y.back()+1!=val && y.back()!=val)
          return;
      }
      y.push_back(val);
    }
  }

  if(x.empty() || y.empty())
    return;

  hitinfo.emplace(hitinfo.end(), HitInfo(
    std::accumulate( x.begin(), x.end(), 0.0) / x.size()*4,
    ((std::accumulate( y.begin(), y.end(), 0.0)) / y.size()-128)*4,
    tof,0,t0,0) );
  return;
}

#endif
