#include <cstdio>
#include <fstream>
#include <vector>
#include <string>
#include <iostream>
#include <fstream>


#include "ParserUtils.hh"
#include "PMTParser.hh"
#include "NumpyHist1D.hh"

int main(int argc, char *argv[])
{
  //read data
  //std::string fname = "/home/dur/BL02/DAQ/RUN0007423/BL02_RUN0007423_He3MODULE_FILE001_20191228134110.dat";
  std::string fname = "RUN0001225/BL18_RUN0001225_MODULE15_FILE001_20190316212625.dat";
  std::ifstream source(fname, std::ifstream::ate|std::ios_base::binary);
  // get length of file:
  source.seekg (0, source.end);
  int length = source.tellg();
  source.seekg (0, source.beg);

  //std::cout<<"223:"<<length<<std::endl;
  // allocate memory:
  const uint8_t * buffer = new uint8_t [length];

  // read data as a block:
  source.read (reinterpret_cast<char*>(const_cast<uint8_t *>(buffer)),length);
  source.close();

  // printf("file size is %d \n", length);
  // std::cout<<333<<std::endl;

  auto *he3 = new Parser::PMTParser();
  std::vector<Parser::HitInfo> hitinfo;
  unsigned loop=0, event_cnt = 0;

  auto hist_pos = new NumpyHist1D(1000,0,300.);

  for(unsigned i=0;i<1;i++){
    const uint8_t * abuf = buffer;
    while(he3->extractNextPackage(abuf, buffer+length, hitinfo))
    {
      loop++;
      event_cnt+=hitinfo.size();
      for(auto v: hitinfo)
      {
        printf("X %d, Y %d, time %d\n", (int)v.pos, (int)v.posy, (int)v.t);
      }
    }
  }
   // printf("hist total %g \n", hist_tube->getIntegral());
  return 0;

}
