#include <dic.hxx>
#include <iostream>
#include <vector>
#include <string>
#include <fstream>
#include <memory>

#include <nlohmann/json.hpp>

#include "DAQInterface.hh"
#include "Hist2DMap.hh"
#include "RedisIO.hh"
#include "Earthworm.hh"
#include "RedisNumpy.hh"
#include "RunStatus.hh"

enum DetType { kUnknown, kHe3, kMWPC  };
int main()
{
	std::cout << "Starting client..." << std::endl;
  unsigned pid_num(1200), tof_num(2500);

	DetType detType = DetType::kUnknown;

	std::string prefix = "/sim";
	std::string cmdPath = prefix+"/MR/control/command/earthworm";
  std::string hbpath = prefix + "/MR/heartbeat/earthworm"; //heartbeat
	std::string mrconfPath = prefix+"/MR/control/configure";


  //dim and hist
	std::string dimAddr = prefix+"/dimserver/TEST_SWAP_1";
  std::string pidPath = prefix + "/MR/workspace/detector/module1/pid";
	std::string tofbinPath = prefix + "/MR/workspace/detector/module1/tof";
	std::string detHistPath = prefix + "/MR/workspace/detector/module1/value";


	std::string mwpcDetCntPath = prefix + "/MR/earthworm/detector_counts";
  std::string he3DetCntPath = prefix + "/MR/earthworm/detector_counts_tube";
  std::string protonChargePath = prefix + "/MR/earthworm/proton_charge";

	std::shared_ptr<RedisIO> redis(
		new RedisIO("10.1.31.116", 9001, "neonmaster", "sanlie;123"));
  //redis should retrive all parameters
  std::shared_ptr<Hist2DMap> histmap(new Hist2DMap(tof_num, 0 , 400000, pid_num, 0, 300) );
	std::shared_ptr<RunStatus> status (new RunStatus(redis,cmdPath,hbpath));

  //RunNumber runNumber;
	DAQInterface daq(dimAddr,100);
  daq.setHist2DMap(histmap);

	std::vector<double> pid;
	for(unsigned i=0;i<pid_num;i++)
	  pid.push_back(i+1);
	RedisNumpy nvt;
  std::string pidstr;
	std::vector<uint64_t> shape;
	shape.push_back(pid_num);
	nvt.makeNumpyArr(pid, RedisNumpy::data_type::f8,
									 shape, pidstr);
	redis->writeString(pidPath, pidstr);

	std::vector<double> tof;
	for(unsigned i=0;i<tof_num+1;i++)
	{
		tof.push_back(i*16);
	}
	std::string tofstr;
	shape[0]=(tof_num+1);
	nvt.makeNumpyArr(tof, RedisNumpy::data_type::f8,
									 shape, tofstr);
	redis->writeString(tofbinPath, tofstr);

	RunStatus::Status lastStatus=RunStatus::Status::kWaiting;
	while(1)
	{
		std::this_thread::sleep_for(std::chrono::milliseconds(1000));
		//heart beat
		redis->writeString(hbpath ,status->genHeartBeat());
		RunStatus::Status sts = status->update();
		if(sts==lastStatus)
		{
			if(sts==RunStatus::Status::kRunning) //update data on redis
			{
				daq.setActiveStatus(true);
				//hist 
		    std::string str;
				histmap->merge(str);
				redis->writeString(detHistPath, str);

				if(detType==DetType::kHe3)
					  redis->writeInt(he3DetCntPath, histmap->getIntegral());
				else if(detType==DetType::kMWPC)
					  redis->writeInt(mwpcDetCntPath, histmap->getIntegral());
				else
				  EW_LOG_CRITICAL("Detector type is unconfigured!");
			}
			else
			{
				continue;
			}
		}

		if(sts==RunStatus::Status::kReady)//start configuration
		{
			std::string conf = redis->readString(mrconfPath);
		  auto j =	nlohmann::json::parse(conf);
			std::string dt= j["mode"];
			if(dt=="He3")
			  detType=DetType::kHe3;
			else if(dt=="MWPC")
			  detType=DetType::kMWPC;
			histmap->reset();

			daq.setActiveStatus(false);
		}
		else if(sts==RunStatus::Status::kReady) //stop update
		{
			daq.setActiveStatus(false);
		}
		else if(sts==RunStatus::Status::kUnconfigured) //abort
		{
			break;
		}
	}

	// std::this_thread::sleep_for(std::chrono::milliseconds(100));
  return 0;
}
