#include "PackageHe3PosCorr.hh"
#include "Earthworm.hh"
#include<cmath>
#include <iostream>
Parser::PackageHe3PosCorr::PackageHe3PosCorr(double threshold_lower, double threshold_upper, double hvlength, double tofscale)
:PackageHe3(threshold_lower, hvlength, tofscale), m_charge_threshold_upper(threshold_upper),
//m_kfactor ({652.021, 654.336, 646.404, 651.417, 644.592, 648.433, 652.676, 652.243, 653.24, 648.828, 652.028, 649.554, 640.401, 642.552, 646.052, 641.191, 638.309, 638.856, 641.175, 641.514, 640.516, 642.203, 638.39, 641.419, 638.458, 644.108, 644.522, 642.148, 641.015, 646.078, 642.319, 639.046, 638.863, 644.927, 639.652, 637.259, 646.996, 639.706, 643.4, 648.561, 646.717, 646.976, 649.141, 642.096, 646.273, 646.459, 642.153, 639.53, 643.897, 647.232, 647.217, 644.928, 642.977, 647.28, 644.519, 650.31, 646.345, 643.279, 641.464, 644.055, 643.541, 642.468, 639.266, 646.766, 642.657, 643.994, 644.495, 642.422, 644.539, 641.171, 640.883, 641.668, 649.729, 645.198, 653.341, 643.322, 648.052, 643.285, 645.499, 645.809, 650.5, 647.664, 643.919, 640.72, 649.052, 647.288, 650.026, 645.833, 651.06, 646.974, 647.717, 644.537, 648.395, 647.669, 646.16, 641.899, 637.929, 643.214, 639.913, 639.665, 641.954, 645.329, 642.226, 640.059, 642.538, 643.824, 654.515, 651.553, 651.945, 644.148, 646.242, 648.156, 646.396, 645.952, 644.829, 647.098, 646.007, 647.186, 646.063, 643.168}),
//m_bfactor ({509.498, 524.227, 504.65, 514.955, 503.662, 495.664, 508.137, 509.367, 486.148, 513.613, 525.655, 513.39, 538.417, 482.455, 511.868, 516.02, 499.218, 510.803, 487.762, 495.786, 502.396, 497.732, 506.726, 481.936, 524.041, 503.362, 482.808, 491.595, 516.966, 514.346, 501.289, 487.656, 493.118, 486.07, 493.49, 482.412, 531.028, 517.884, 530.924, 541.751, 516.465, 513.633, 547.366, 509.207, 529.584, 548.797, 485.059, 517.257, 470.795, 504.579, 462.171, 487.16, 491.95, 476.097, 475.509, 463.019, 449.527, 480.352, 491.776, 471.874, 490.637, 483.131, 512.703, 499.938, 502.398, 486.196, 506.583, 494.829, 494.442, 508.431, 505.361, 525.168, 474.713, 496.15, 454.889, 507.377, 491.325, 499.436, 470.139, 472.651, 449.392, 459.263, 497.304, 483.981, 512.078, 498.4, 517.587, 509.268, 505.854, 502.457, 503.469, 513.076, 476.583, 506.454, 488.657, 514.141, 500.764, 520.459, 494.249, 492.623, 522.478, 501.383, 493.044, 507.371, 504.02, 499.569, 489.668, 538.796, 524.269, 517.752, 522.742, 532.115, 516.139, 490.966, 526.688, 506.279, 519.686, 560.481, 537.823, 540.212})
a1({-186.936, -94.3063, -187.091, -97.6019, -186.883, -188.382, -187.079, -186.916, -190.014, -120.05, -110.585, -113.809, -119.12, -189.384, -112.951, -110.432, -186.686, -110.413, -188.562, -187.285, -186.688, -187.304, -149.831, -189.331, -169.586, -186.801, -189.179, -187.894, -121.567, -90.0094, -186.696, -188.096, -187.185, -189.146, -187.299, -188.665, -108.596, -118.438, -127.338, -105.786, -121.003, -133.845, -108.318, -160.289, -112.78, -100.571, -188.975, -170.653, -190.476, -186.65, -192.229, -188.659, -187.815, -190.446, -189.923, -192.601, -194.172, -188.852, -187.35, -190.528, -188.066, -189.169, -80.7503, -187.43, -186.854, -188.88, -146.212, -187.6, -187.785, -81.1653, -58.0333, -96.1977, -191.187, -187.651, -194.139, -186.195, -188.445, -187.024, -191.237, -191.099, -194.873, -193.504, -187.073, -188.993, -141.997, -187.597, -116.871, -148.196, -187.224, -187.202, -187.337, -150.503, -190.837, -186.828, -188.557, -153.943, -186.064, -114.568, -185.903, -187.449, -139.89, -187.402, -188.232, -186.47, -186.555, -185.456, -189.981, -146.513, -141.753, -118.194, -155.099, -135.957, -126.672, -188.173, -151.022, -186.525, -137.724, -86.0478, -127.005, -106.683}),
a2({-1.81381, -2.51047, -1.79394, -2.43341, -1.77688, -1.81098, -1.80523, -1.831, -1.81291, -2.20183, -2.28425, -2.27726, -2.13606, -1.77629, -2.27087, -2.25474, -1.76464, -2.27192, -1.77885, -1.76736, -1.78714, -1.83888, -1.94353, -1.75088, -1.78016, -1.80065, -1.77916, -1.76501, -2.14516, -2.52692, -1.76764, -1.74961, -1.74507, -1.79495, -1.7408, -1.75242, -2.29921, -2.19123, -2.09526, -2.3304, -2.19432, -2.10053, -2.27674, -1.89776, -2.24803, -2.34368, -1.75098, -1.80703, -1.72692, -1.77292, -1.71918, -1.75481, -1.74989, -1.75716, -1.72534, -1.74672, -1.7255, -1.71922, -1.71802, -1.74185, -1.84679, -1.85029, -2.66369, -1.8947, -1.84035, -1.84483, -2.05531, -1.82621, -1.81696, -2.65089, -3.1227, -2.45462, -1.78849, -1.76301, -1.78574, -1.76547, -1.77242, -1.75992, -1.73615, -1.74829, -1.74523, -1.8163, -1.72343, -1.74277, -2.02909, -1.7713, -2.23383, -1.97416, -1.81889, -1.79234, -1.7963, -1.96416, -1.76311, -1.79376, -1.76426, -1.92472, -1.73394, -2.20621, -1.703, -1.73886, -2.01077, -1.79465, -1.77032, -1.78982, -1.7686, -1.71004, -1.72419, -1.96147, -2.04088, -2.22162, -1.91013, -2.03798, -2.14023, -1.76726, -1.93222, -1.77636, -2.04243, -2.4883, -2.09113, -2.26992}),
a3({635.798, 516.16, 629.744, 512.062, 626.559, 626.1, 632.697, 640.279, 617.266, 542.335, 538.561, 534.634, 558.138, 612.764, 531.637, 530.441, 624.434, 527.065, 617.632, 621.782, 630.432, 639.541, 576.426, 607.309, 615.979, 633.279, 614.454, 617.876, 545.892, 501.574, 625.185, 613.029, 616.522, 618.146, 614.818, 610.879, 541.451, 544.413, 565.55, 546.776, 547.651, 562.944, 552.647, 593.598, 544.645, 541.822, 609.031, 611.377, 596.942, 626.869, 588.323, 611.478, 614.521, 603.508, 598.891, 592.216, 582.393, 602.102, 608.613, 599.888, 636.226, 629.823, 492.109, 651.471, 643.039, 630.504, 584.506, 634.525, 631.143, 488.482, 454.19, 526.383, 606.424, 618.677, 592.913, 627.51, 616.742, 621.289, 595.674, 598.759, 583.357, 600.651, 611.362, 607.037, 571.238, 621.057, 541.432, 576.831, 635.196, 628.664, 628.851, 582.668, 602.969, 631.312, 614.228, 587.952, 619.357, 540.915, 611.317, 613.561, 575.455, 628.045, 617.373, 632.505, 626.255, 615.55, 598.389, 589.762, 581.484, 545.114, 595.902, 578.506, 552.62, 616.943, 592.129, 628.532, 571.246, 527.197, 570.318, 543.831}),
a4({654.111, 649.727, 648.207, 650.101, 646.088, 648.652, 653.972, 655.161, 651.492, 645.726, 649.235, 648.702, 635.058, 639.045, 643.675, 639.637, 639.173, 636.706, 638.186, 641.449, 641.473, 641.218, 637.559, 639.47, 638.872, 643.906, 641.206, 639.902, 638.608, 642.608, 642.966, 637.215, 639.496, 643.316, 639.403, 634.763, 640.386, 635.259, 637.894, 640.805, 642.87, 643.279, 642.524, 639.102, 641.443, 638.685, 641.293, 636.143, 637.64, 647.705, 641.18, 642.459, 643.408, 643.482, 639.175, 644.241, 639.398, 638.891, 641.682, 640.934, 647.644, 644.469, 639.391, 648.932, 644.372, 643.651, 646.625, 645.456, 647.246, 642.012, 640.755, 639.219, 648.102, 647.486, 647.833, 645.726, 650.242, 644.988, 642.182, 642.971, 644.695, 644.391, 646.466, 640.405, 648.189, 649.155, 647.794, 644.72, 653.442, 648.917, 649.229, 642.407, 647.249, 649.209, 648.239, 639.916, 640.183, 643.08, 644.108, 643.118, 640.35, 647.41, 643.711, 641.883, 644.321, 643.645, 641.446, 637.237, 649.61, 643.02, 645.342, 645.295, 643.991, 648.564, 643.774, 650.402, 644.238, 639.595, 643.032, 640.164}),
a5({510.133, 526.12, 504.367, 516.861, 503.708, 495.341, 508.193, 511.0, 485.284, 514.733, 527.743, 514.519, 539.945, 481.666, 512.135, 518.141, 499.392, 511.313, 487.032, 496.832, 503.071, 497.361, 507.502, 481.029, 529.493, 503.925, 483.198, 491.551, 518.319, 516.029, 502.419, 487.586, 494.159, 485.986, 493.339, 482.74, 533.209, 519.89, 533.056, 543.817, 518.651, 514.902, 549.906, 511.133, 531.27, 551.303, 485.938, 519.767, 469.227, 504.736, 460.851, 486.134, 492.445, 475.153, 474.335, 461.346, 447.799, 480.221, 492.21, 472.132, 494.68, 485.463, 515.391, 501.803, 504.978, 488.526, 509.668, 497.403, 497.189, 512.11, 508.835, 528.788, 473.933, 496.102, 453.364, 507.394, 491.704, 499.642, 469.497, 470.941, 447.787, 457.68, 497.309, 483.519, 514.088, 498.596, 519.247, 511.368, 506.737, 503.094, 503.832, 514.443, 476.126, 506.737, 489.811, 515.847, 502.831, 526.928, 502.211, 495.038, 524.414, 502.155, 493.304, 507.831, 504.851, 506.737, 476.834, 531.111, 526.779, 521.116, 526.517, 536.412, 517.387, 493.316, 529.132, 509.449, 523.585, 563.981, 542.209, 544.567}),
a6({189.155, 190.973, 187.661, 190.152, 187.48, 186.649, 188.877, 189.278, 180.953, 189.285, 191.612, 189.419, 192.09, 169.756, 188.705, 189.121, 186.276, 187.349, 173.623, 186.104, 186.844, 186.33, 187.447, 147.877, 191.026, 186.994, 173.75, 214.026, 188.901, 188.914, 186.913, 239.18, 185.441, 226.135, 185.402, 230.407, 190.942, 188.298, 190.964, 192.533, 189.186, 188.587, 193.985, 187.547, 190.887, 193.818, 244.161, 188.494, 122.223, 188.249, 134.69, 151.909, 185.969, 125.615, 172.978, 149.046, 120.234, 149.545, 185.983, 131.087, 186.974, 67.4078, 188.907, 188.061, 188.111, 70.8281, 188.732, 187.12, 187.257, 188.826, 188.414, 190.763, 122.634, 186.809, 131.363, 187.997, 186.751, 186.899, 131.126, 181.494, 116.025, 138.407, 187.115, 151.147, 189.295, 187.363, 190.017, 188.644, 188.455, 187.347, 187.596, 188.493, 120.582, 188.274, 186.027, 188.635, 186.945, 190.976, 187.633, 186.032, 190.127, 187.078, 185.762, 186.144, 187.416, 188.416, 146.206, 190.577, 191.155, 189.557, 190.929, 192.432, 189.165, 186.615, 190.917, 188.485, 190.193, 196.088, 193.117, 193.118}),
a7({1.79943, 1.75058, 1.75327, 1.78205, 1.74231, 1.75506, 1.76532, 1.75612, 1.78147, 1.7577, 1.76761, 1.75808, 1.69904, 1.80411, 1.73223, 1.72049, 1.72098, 1.67599, 1.78186, 1.71396, 1.72056, 1.72475, 1.74173, 1.9565, 1.93358, 1.70235, 1.79755, 1.59706, 1.70087, 1.70659, 1.70004, 1.48536, 1.70129, 1.54075, 1.69601, 1.50552, 1.69351, 1.66188, 1.70616, 1.66889, 1.7071, 1.69914, 1.71332, 1.70146, 1.70774, 1.67749, 1.46047, 1.67871, 2.15908, 1.77996, 2.05166, 1.93936, 1.73695, 2.13958, 1.81072, 1.95629, 2.1439, 1.96325, 1.75108, 2.07481, 1.84093, 2.86683, 1.82195, 1.86742, 1.85533, 2.87278, 1.85368, 1.85376, 1.90473, 1.86036, 1.83072, 1.8516, 2.1568, 1.76268, 2.07149, 1.74562, 1.78899, 1.74451, 2.05459, 1.74233, 2.1805, 1.97545, 1.79299, 1.90806, 1.76061, 1.7674, 1.77218, 1.75141, 1.75577, 1.71204, 1.74092, 1.73553, 2.16847, 1.7629, 1.7486, 1.71912, 1.72865, 1.78744, 1.81843, 1.73627, 1.76232, 1.71919, 1.74275, 1.67448, 1.74562, 1.95337, 1.95751, 1.72623, 1.7629, 1.72203, 1.74927, 1.7213, 1.72838, 1.75718, 1.71818, 1.73727, 1.75602, 1.69557, 1.75015, 1.72816}),
a8({380.933, 400.2, 383.834, 389.845, 385.703, 377.952, 387.151, 391.236, 380.547, 390.911, 399.585, 391.473, 415.024, 392.758, 394.105, 398.747, 385.383, 402.38, 391.937, 386.511, 388.287, 384.595, 385.686, 418.18, 367.28, 393.875, 387.384, 344.523, 402.469, 401.152, 394.131, 312.799, 386.947, 327.497, 388.32, 320.231, 412.095, 409.667, 409.464, 422.704, 402.167, 401.589, 419.137, 396.572, 408.834, 425.02, 306.668, 406.232, 442.548, 380.415, 419.571, 417.567, 379.28, 442.766, 380.014, 400.58, 430.682, 414.314, 375.331, 433.908, 357.717, 533.195, 374.591, 359.243, 362.23, 523.529, 366.721, 355.645, 345.172, 365.945, 369.663, 379.421, 448.097, 376.793, 420.555, 387.459, 369.493, 382.133, 433.783, 368.952, 437.731, 417.275, 370.671, 418.558, 390.302, 378.648, 391.268, 389.251, 387.275, 392.917, 386.642, 392.328, 452.09, 384.635, 376.285, 396.943, 386.609, 392.767, 367.587, 379.811, 393.906, 389.775, 376.485, 397.87, 384.523, 345.114, 417.997, 403.598, 398.487, 400.27, 400.283, 412.002, 397.094, 377.191, 406.682, 391.869, 395.562, 428.919, 409.161, 413.265})
{

}

Parser::PackageHe3PosCorr::~PackageHe3PosCorr(){}

bool Parser::PackageHe3PosCorr::extractNextPackage(const uint8_t*& pt, const uint8_t * const stream_end, std::vector<HitInfo>& hitinfo) const
{
  const uint8_t *package_end;
  uint64_t offset=0;

  if(!findNextPackageStartEnd(stream_end, pt, package_end, offset))
    return false;

  Parser::ParserHe3::Header *header = new Parser::ParserHe3::Header();
  readHeader(pt, header);

  Parser::ParserHe3::Info info;
  readInfo(pt, info);
  double baseline_factor = 1./info.sample_num_bl;



  std::vector<HitInfo> temp;
  std::swap(temp,hitinfo);
  hitinfo.reserve(info.hit_cnt);
  if(info.hit_cnt)
  {
    Parser::ParserHe3::Hit hit ;
    //the next while loop breaks when pt==package_end-8
    while (pt != package_end-8) {
      //error_assert(pt<package_end-8); //shouldn't really happen
      readHit(pt,hit);
      int32_t upper = hit.upper_charge - hit.upper_baseline*baseline_factor;
      int32_t lower = hit.lower_charge - hit.lower_baseline*baseline_factor;
      int32_t tot = upper + lower;
      if(!tot || tot<=m_charge_threshold || tot>=m_charge_threshold_upper)
        continue;
      else if(header->module>10)
      {
        EW_LOG_WARN("Module id is greater than 10");
      }
      else
      {
        unsigned index = 12*(header->module-1) + hit.tube_id;
        //int32_t x    = m_kfactor[index]*(lower-upper)/(tot) + m_bfactor[index];
        float r = (lower-upper)*1.0/tot;
	int32_t x = 0;
	if (r< -0.4)
	{
	  x=a1[index]*exp(a2[index]*r)+a3[index];
	}
	if(r<=0.4 && x>= -0.4)
	{
	  x=a4[index]*r+a5[index];
	}
	if(r>0.4)
	{
	  x=a6[index]*exp(a7[index]*r)+a8[index];
	}
	//std::cout<<"index="<<index<<"||"<<"r="<<r<<"||"<<lower<<"||"<<upper<<"||"<<"x="<<x<<std::endl;
	if(x < 0 || x > 1000)
          continue;
        hitinfo.push_back(HitInfo( x , hit.tube_id,
        hit.time*m_tof2us, tot, info.t0_count, header->module));
      }
    }
  }
  pt = package_end;

  delete header;

  //printf("left %ld, package_end %p, stream_end %p\n", stream_end-package_end, package_end, stream_end);
  return package_end==stream_end?false:true;

}
