#include "parserXML.h"
#include "parserNXS.h"
#include <limits>
#include <typeinfo>
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <fstream>
#include "NeXusFile.hpp"
#include <vector>
#include <dirent.h>
#include <unistd.h>
#include <numeric>
#include "ParserUtils.hh"
#include "PackageHe3.hh"
#include "PackageHe3PosCorr.hh"
#include "NumpyHist1D.hh"
#include "NumpyHist2D.hh"

#include "ParserUtils.hh"
#include "PMTParser.hh"
#include "FileSysHelper.hh"
#include <sys/io.h>
//#include <experimental/filesystem>
using namespace std;
//namespace fs=std::experimental::filesystem;


/*
 *get file 
 * */

std::string ParserNXS::getOneFile(const std::string &filepath, const std::string &midName, const std::string &suffixName)
{
        std::string filename;
        DIR *dirp;
        struct dirent *dp;
	if (access(filepath.c_str(),0)==-1)
	{ filename="";
	}else{ 
       		dirp=opendir(filepath.c_str());
        while((dp = readdir(dirp))!=NULL)
        {
                std::string name = dp->d_name;
                int num=name.size();
                if((name.size()>4) && (name.compare(num-3,3,suffixName)==0))
                {
                    auto iPos = name.find(midName);
                    if(iPos!=name.npos)
                        filename = filepath+"/"+name;
                }
         }
	closedir(dirp);}
	//delete dirp;
	//delete dp;
	return filename;
}

void ParserNXS::getSumFile(ParserXML conf_xml)
{
        const int no = atoi(runno.substr(3).c_str());
        stringstream ss;
        ss<<no;
        const string run = ss.str();
        string filepath = conf_xml.getPath_CONF("controlPath", bl);
        filepath = filepath + "/"+runno;
	cout<<"summary: "<<filepath<<" || "<<run<<endl;
        sumfile = getOneFile(filepath,run,"xml");
}

void ParserNXS::getPCFile(ParserXML conf_xml)
{
	const int no = atoi(runno.substr(3).c_str());
        stringstream ss;
        ss<<no;
        const string run = ss.str();
        string filepath = conf_xml.getPath_CONF("pcPath", bl);
        filepath = filepath + "/"+runno;
        cout<<"pc: "<<filepath<<" || "<<run<<endl;
        pcfile = getOneFile(filepath,run,"txt");
}

void ParserNXS::getRecType(ParserXML conf_xml)
{
	datatype=conf_xml.getPath_CONF("dataType", bl);
}

void ParserNXS::getDAQFile(ParserXML conf_xml)
{
        string filepath = conf_xml.getPath_CONF("daqPath", bl);
        filepath = filepath + "/"+runno;
        moduleList=conf_xml.getModuleList_CONF("bank", bl);
	for(const auto &it : moduleList)
	{
	    std::string mName = it; 
            if (bl=="BL18")
            {
                std::map<std::string, std::string> info = conf_xml.getPid_CONF(mName, bl);
                const string modNum = info.find("moduleNum")->second;
                string name = "MODULE"+modNum;
                std::string daqfile = getOneFile(filepath, name, "dat");
		moduleFilelist.insert(make_pair(mName, daqfile));
            }
	    if (bl=="BL01")
	    {	
		for(int k=1; k<=10; k++)
		{
		    std::string str = std::to_string(k);
		    if (str.size()<2)
			str = "0"+str;
		    string name = "MODULE"+str;
		    std::string daqfile = getOneFile(filepath, name, "dat");
		    moduleFilelist_sans.push_back(daqfile);
		}

	    }
	}
}

void ParserNXS::getMonFile(ParserXML conf_xml)
{
        string filepath = conf_xml.getPath_CONF("monPath", bl);
    	std::vector<std::string> monitorList=conf_xml.getModuleList_CONF("monitor", bl);
	for(const auto &it : monitorList)
	{
	    std::string mName = it;
	    std::string upName = mName;
	    upName[0]=toupper(upName[0]); 
            std::string filepath2 = filepath + "/"+upName+"/"+runno;
	    std::string monfile = getOneFile(filepath2, runno, "bin");
	    cout<<"find monitor file: "<<mName<<"||"<<monfile<<endl;
	    monitorFilelist.insert(make_pair(mName, monfile));
	}
}

void ParserNXS::getNXSname(ParserXML conf_xml)
{
	std::string filepath = conf_xml.getPath_CONF("prePath",bl);
	nxsfile = filepath+"/"+runno+"/detector.nxs";
}

void ParserNXS::getIDFname(ParserXML conf_xml)
{
	std::string filepath = conf_xml.getPath_CONF("idfPath",bl);
	idf_bank = filepath+"/bank.xml";
	idf_monitor = filepath+"/monitor.xml";

}

/*
 * test
 * */
void ParserNXS::coutMap(map<string, string> info)
{
    for(auto it = info.begin(); it!=info.end(); it++)
        cout<<it->first<<"||"<<it->second<<endl;
}

string ParserNXS::int2string(int num)
{
    stringstream ss;
    ss<<num;
    string tmp = ss.str();
    return tmp;
}

bool ParserNXS::judgeMap(map<string, string> data)
{
    auto it = data.begin();
    if(it==data.end() || (it->first)=="None")
    {    return false;
    }else{
        return true;
    }
}

bool ParserNXS::judgeVector(const vector<map<string, string> > &data)
{
    auto it = data.begin();
    if(it==data.end())
    {    return false;
    }else{
        map<string, string> tmp = *it;
        auto it2 = tmp.begin();
        if(it2->first == "None")
        {return false;
        }else{
        return true;}
    }
}

string ParserNXS::getStringFromMap(const map<string, string> data, string name)
{
    string tmp="";
    auto it = data.find(name);
    if(it!= data.end())
    {    tmp = it->second;
    }else{
         tmp = "None";}
    return tmp;
}
float ParserNXS::getFloatFromMap(const map<string, string> data, string name)
{
    auto it = data.find(name);
    float tmp = 0.0;
    if(it!= data.end())
        tmp = atof(it->second.c_str());
    return tmp;
}
int ParserNXS::getIntFromMap(const map<string, string> data, string name)
{
    auto it = data.find(name);
    int tmp = 0;
    if(it!= data.end())
        tmp = atoi(it->second.c_str());
    return tmp;
}
map<string, string> ParserNXS::getMapFromVector(const vector<map<string, string> >& data, string keyword, string value)
{
    map<string, string> tmp;
    for(auto it=data.begin(); it!=data.end(); it++)
    {
        string str1 = getStringFromMap(*it, keyword);
        if(0==strcmp(str1.c_str(), value.c_str()))
            tmp=*it;
    }
    return tmp;
}

vector<string> ParserNXS::split(string str, string sep)
{
   char* cstr=const_cast<char*>(str.c_str());
    char* current;
    std::vector<std::string> arr;
    current=strtok(cstr,sep.c_str());
    while(current!=NULL){
        arr.push_back(current);
        current=strtok(NULL,sep.c_str());
    }
    return arr;
}

/*
void ParserNXS::getMRData(string daqFile, const int pidNum, const int pidStart, const int pidEnd,  const int tofNum, const int tofStart, const int tofEnd, uint64_t& evtNum, std::vector<int64_t> &pid, std::vector<float> &tof, std::vector<uint64_t> &pulse, std::vector<uint32_t> &histData)
{

    NumpyHist2D hist2(pidNum, pidStart, pidEnd, tofNum, tofStart, tofEnd);
    uint32_t n = 0;            
    std::ifstream source(daqFile, std::ifstream::ate|std::ios_base::binary);
    source.seekg (0, source.end);
    int length = source.tellg();
    source.seekg (0, source.beg);
    const uint8_t * buffer = new uint8_t [length];
    source.read (reinterpret_cast<char*>(const_cast<uint8_t *>(buffer)),length);
    source.close();
    
    auto *he3 = new Parser::PackageHe3(0.);
    std::vector<Parser::HitInfo> hitinfo;
    unsigned loop=0, event_cnt = 0;

    const uint8_t * abuf = buffer;
    std::map<uint32_t, uint32_t> mapfile;
    mapfile.insert(make_pair(7,1));
    mapfile.insert(make_pair(8,2));
    mapfile.insert(make_pair(9,3));
    mapfile.insert(make_pair(11,4));
    uint32_t tmp=0;
    uint32_t m_bins = 300;
    while(he3->readNextPackage(abuf, buffer+length, hitinfo))
    {
        event_cnt+=hitinfo.size();
        for(auto v: hitinfo)
        {
            tmp = mapfile[v.id];
            int pixelID = 100001+m_bins*(tmp-1)+int(v.pos);
            pid.push_back(pixelID);
            tof.push_back(v.t);
            pulse.push_back(v.hit_t0);
            hist2.fill(pixelID, v.t);
            n++;
        }
    }

    evtNum = n-1;
    cout<<"evt num: "<<evtNum<<endl;
    auto tmp2 = hist2.getRaw();
    for(unsigned i=0;i<tmp2.size();i++)
        histData.push_back(tmp2[i]);

}
*/
void ParserNXS::setSANSData(NXstatus status, NXhandle fileID, const int pidNum, const int pidStart, float lowerValue, float upperValue)

{
   //int pidEnd = pidStart+pidNum; 
    //NumpyHist2D hist2(timeBin_bank-1, timeStart_bank, timeEnd_bank, float(pidNum), float(pidStart), float(pidStart+pidNum));
    NumpyHist2D hist2(10000, 0, 40000, 15000.0, 100001.0-0.5, 115000.0+0.5);
    uint32_t n = 0;            
    uint32_t tmp = 0;
    int x=0;
    int y=0;
    int module=0;
    int dim[1]={1};
    for(auto it=moduleFilelist_sans.begin();it!=moduleFilelist_sans.end();it++)
    {
    	std::vector<uint64_t> pidList;
    	std::vector<float> tofList;
    	std::vector<uint64_t> pulseList;
        
	string filename = *it;
	//cout<<"start get data from: "<<filename<<endl;
        std::ifstream source(filename, std::ifstream::ate|std::ios_base::binary);
        source.seekg (0, source.end);
        uint64_t length = source.tellg();
	uint64_t one = 1;
	if (length >(one<<32))
	{
	std::cout<<"Warning: This file is more than 4G!!!"<<std::endl;
	throw -1;
	}
	//cout<<"lenth: "<<length<<endl;
        source.seekg (0, source.beg);
        const uint8_t * buffer = new uint8_t [length];
        source.read (reinterpret_cast<char*>(const_cast<uint8_t *>(buffer)),length);
        source.close();
        auto *he3 = new Parser::PackageHe3PosCorr(lowerValue,upperValue);
        std::vector<Parser::HitInfo> hitinfo;
        unsigned loop=0, event_cnt = 0;
	const uint8_t * const  endpos = buffer+length;        
	const uint8_t * abuf = buffer;
        while(he3->extractNextPackage(abuf, endpos, hitinfo))
        {
            event_cnt+=hitinfo.size();
		
            for(auto v: hitinfo)
            {   
                x=v.pos;
		//std::cout<<"x="<<x<<std::endl;
                module = v.id;
                y = v.posy;
                tmp = 120-(12*(module-1)+y);
                int pixelID = 100001+125*(tmp-1)+uint32_t(x/(1000/125));
		//cout<<pixelID<<"||"<<v.t<<endl;
    		if (datatype.compare("event") == 0){
            	    pidList.push_back(pixelID);
            	    tofList.push_back(v.t);
            	    pulseList.push_back(v.hit_t0);
		}
            hist2.fill(v.t,pixelID);
            n++;
	    }
        }
		
        
	uint64_t evtNum = pidList.size();
    	dim[0]=evtNum;
        cout<<"evt num : "<<evtNum<<endl;
	string sufname=to_string(module);
        writeNumData(status, fileID, "event_pixel_id_"+sufname, pidList.data(), 1, dim, "");
        writeNumData(status, fileID, "event_time_of_flight_"+sufname, tofList.data(), 1, dim, "");
        writeNumData(status, fileID, "event_pulse_time_"+sufname, pulseList.data(), 1, dim, "");
        pidList.clear();
        tofList.clear();
        pulseList.clear();
        //cout<<"345"<<endl; 
        delete [] buffer;
        delete he3;
        cout<<"finish: "<<filename<<endl;
    }
    auto tmp2 = hist2.getRaw();
    std::vector<uint32_t> histData;
    std::copy(tmp2.cbegin(), tmp2.cend(), std::back_inserter(histData));
        int slab_size[2]={pidNum,(timeBin_bank-1)};
        int slab_start[2]={0,0};
        int dim2D[2]={pidNum, timeBin_bank-1};
        writeSlabData(status, fileID, "histogram_data",histData.data(), dim2D, slab_start, slab_size, "");
        histData.clear();
/*
    if (datatype.compare("event") == 0){
	    uint64_t evtNum = pidList.size();
    	int dim[1]={1};
    	dim[0]=evtNum;
        cout<<"evt num : "<<evtNum<<endl;
        writeNumData(status, fileID, "event_pixel_id", pidList.data(), 1, dim, "");
        writeNumData(status, fileID, "event_time_of_flight", tofList.data(), 1, dim, "");
        writeNumData(status, fileID, "event_pulse_time", pulseList.data(), 1, dim, "");}
        pidList.clear();
        tofList.clear();
        pulseList.clear();
*/
}



/*
void ParserNXS::getEventData(string daqFilename, uint64_t& evtNum, std::vector<int64_t> &pid, std::vector<float> &tof, std::vector<uint64_t> &pulse)
{
    std::ifstream source(daqFilename, std::ifstream::ate|std::ios_base::binary);
    source.seekg (0, source.end);
    int length = source.tellg();
    source.seekg (0, source.beg);
    const uint8_t * buffer = new uint8_t [length];
    //cout<<456<<endl;
    source.read (reinterpret_cast<char*>(const_cast<uint8_t *>(buffer)),length);
    source.close();

    auto *he3 = new Parser::PackageHe3(0.);
    std::vector<Parser::HitInfo> hitinfo;
    unsigned loop=0, event_cnt = 0;

    const uint8_t * abuf = buffer;
     std::map<uint32_t, uint32_t> mapfile;
        mapfile.insert(make_pair(7,1));
        mapfile.insert(make_pair(8,2));
        mapfile.insert(make_pair(9,3));
        mapfile.insert(make_pair(11,4));
        uint32_t tmp=0;
        uint32_t m_bins = 300;
    uint32_t n = 0;
    while(he3->readNextPackage(abuf, buffer+length, hitinfo))
    {
      event_cnt+=hitinfo.size();
      for(auto v: hitinfo)
      {
        tmp = mapfile[v.tube_id];
        pid.push_back(100001+m_bins*(tmp-1)+int(v.pos));
        tof.push_back(v.t);
        pulse.push_back(v.hit_t0);
        n++;
      }
    }
    evtNum = n-1;
    cout<<"evt num: "<<evtNum<<endl;
}





*/

void ParserNXS::writeGroup(NXstatus status, NXhandle fileID, const char* groupName, const char* groupType)
{
    status=NXmakegroup(fileID,groupName,groupType);
    status=NXopengroup(fileID,groupName,groupType);
}
void ParserNXS::writeCharData(NXstatus status, NXhandle fileID, const std::string dataName, const std::string dataValue)
{
    long unsigned int dsize = dataValue.size();
    if(dsize > std::numeric_limits<int>::max() )
      throw std::runtime_error("ParserNXS::writeCharData, each dimension of the data can't contain more than 2^31 elements");
    int dim[1] = {static_cast<int>(dsize)};
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID,p,NeXus::CHAR,1,dim);
    status=NXopendata(fileID,p);
    status=NXputdata(fileID,dataValue.c_str());
    status=NXclosedata(fileID);
}
//write slab data
void ParserNXS::writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const float* dataValue, int dim[], int slab_start[], int slab_size[], std::string text)
{
    char* p = (char*)dataName.data();
    //status=NXmakedata(fileID, p, NX_FLOAT32, 2, dim);
    status=NXcompmakedata(fileID, p, NX_FLOAT32, 2, dim, NX_COMP_LZW, slab_size);
    status=NXopendata(fileID, p);
    status=NXputslab(fileID, dataValue, slab_start, slab_size);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}

void ParserNXS::writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const int64_t* dataValue, int dim[], int slab_start[], int slab_size[], std::string text)
{
    char* p = (char*)dataName.data();
    status=NXcompmakedata(fileID, p, NX_INT64, 2, dim, NX_COMP_LZW, slab_size);
    //status=NXmakedata(fileID, p, NX_INT64, 2, dim);
    status=NXopendata(fileID, p);
    status=NXputslab(fileID, dataValue, slab_start, slab_size);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}
void ParserNXS::writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const uint32_t* dataValue, int dim[], int slab_start[], int slab_size[], std::string text)
{
    char* p = (char*)dataName.data();
    //status=NXmakedata(fileID, p, NX_INT32, 2, dim);
    status=NXcompmakedata(fileID, p, NX_INT32, 2, dim, NX_COMP_LZW, slab_size);
    status=NXopendata(fileID, p);
    status=NXputslab(fileID, dataValue, slab_start, slab_size);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}

//if dataValue is a variable, use &dataValue; if dataVale is 2D array, use *dataValue, if dataValue is 1D array, use dataValue
void ParserNXS::writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const float* dataValue, int dimension, int dim[], std::string text)
{
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID, p, NX_FLOAT32, dimension, dim);
    status=NXopendata(fileID, p);
    status=NXputdata(fileID, dataValue);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}
void ParserNXS::writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const int64_t* dataValue, int dimension, int dim[], std::string text)
{
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID, p, NX_INT64, dimension, dim);
    status=NXopendata(fileID, p);
    status=NXputdata(fileID, dataValue);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}
void ParserNXS::writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const uint64_t* dataValue, int dimension, int dim[], std::string text)
{
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID, p, NX_INT64, dimension, dim);
    status=NXopendata(fileID, p);
    status=NXputdata(fileID, dataValue);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}
void ParserNXS::writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const uint32_t* dataValue, int dimension, int dim[], std::string text)
{
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID, p, NX_INT32, dimension, dim);
    status=NXopendata(fileID, p);
    status=NXputdata(fileID, dataValue);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}



void ParserNXS::getConfInfo()
{
    cout<<"start get conf: "<<confName<<endl;
    ParserXML conf_xml(confName);
    getSumFile(conf_xml);
    getPCFile(conf_xml);
    getRecType(conf_xml);
    getNXSname(conf_xml);
    getIDFname(conf_xml);
    cout<<"1: "<<nxsfile<<endl;
    cout<<"2: "<<sumfile<<endl;
    // tof infomation
    map<string, string> tofInfo_bank = conf_xml.getTofInfo_CONF("bankTofInformation",bl);
    map<string, string> tofInfo_monitor = conf_xml.getTofInfo_CONF("monTofInformation",bl);
    timeBin_bank = getIntFromMap(tofInfo_bank, "tofbin")+1; 
    timeStart_bank = getIntFromMap(tofInfo_bank, "tofstart");
    timeStep_bank = getIntFromMap(tofInfo_bank, "tofstep");
    timeEnd_bank = timeStart_bank+timeStep_bank*(timeBin_bank-1);
    getDAQFile(conf_xml);
    getMonFile(conf_xml);

    timeBin_monitor = getIntFromMap(tofInfo_monitor, "tofbin")+1; 
    timeStart_monitor = getIntFromMap(tofInfo_monitor, "tofstart");
    timeStep_monitor = getIntFromMap(tofInfo_monitor, "tofstep");
    timeEnd_monitor = timeStart_monitor+timeStep_monitor*(timeBin_monitor-1);

}

void ParserNXS::createNXS()
{
    NXaccess mode(NXACC_CREATE5);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    status=NXmakegroup(fileID,"csns","NXentry");
    status=NXopengroup(fileID,"csns","NXentry");
    writeGroup(status, fileID, "instrument", "NXinstrument");
    NXclosegroup(fileID); 
    writeGroup(status, fileID, "event_data", "NXcollection");
    NXclosegroup(fileID);
    writeGroup(status, fileID, "histogram_data", "NXcollection");
    NXclosegroup(fileID);
    writeGroup(status, fileID, "process", "NXprocess");
    NXclosegroup(fileID);
    writeGroup(status, fileID, "user", "NXuser");
    NXclosegroup(fileID);
    writeGroup(status, fileID, "logs", "NXcollection");
    NXclosegroup(fileID);

    NXclosegroup(fileID); //close NXentry
    NXclosegroup(fileID); //close csns
    NXclose(&fileID);
}

/***
 * set value into nexus
 ***/


/*
 * first-level group
 * public, instrument, logs, user,process, event_Data, histogram_data
 * */
void ParserNXS::setPublic()
{
    ParserXML new_xml(sumfile);

    int dim[1]={1};
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    status=NXopengroup(fileID,"csns","NXentry");
    map<std::string, std::string> info = new_xml.getPublic_SUM();
    writeCharData(status, fileID, "description", getStringFromMap(info,"description"));
    writeCharData(status, fileID, "beamline",getStringFromMap(info,"beamline"));
    writeCharData(status, fileID, "start_time_utc",getStringFromMap(info,"start_time_utc"));
    writeCharData(status, fileID, "end_time_utc",getStringFromMap(info,"end_time_utc"));
    writeCharData(status, fileID, "proposal_id", getStringFromMap(info,"proposal_id"));
    writeCharData(status, fileID, "instrument_name",getStringFromMap(info,"instrument_name"));
    writeCharData(status, fileID, "start_time_tai", getStringFromMap(info,"start_time_tai"));
    writeCharData(status, fileID, "end_time_tai", getStringFromMap(info,"end_time_tai"));
    writeCharData(status, fileID, "run_no", getStringFromMap(info,"run_no"));
    writeCharData(status, fileID, "measurement_type", getStringFromMap(info,"measurement_type"));
    writeCharData(status, fileID, "version", "1.0");
    writeCharData(status, fileID, "wavelength", getStringFromMap(info,"wavelength"));
    writeCharData(status, fileID, "proton_charge",getStringFromMap(info,"proton_charge"));

    info.clear();
    writeCharData(status, fileID, "instrument_bank_file", "bank.xml");
    //writeCharData(status, fileID, "instrument_monitor_file", "monitor.xml");
    std::string det_definition = "";
    //std::string mon_definition = "";
    fstream fileidf;
    fileidf.open(idf_bank, std::ios::in);
    std::stringstream tmp1;
    tmp1<<fileidf.rdbuf();
    det_definition = tmp1.str();
    fileidf.close();
    //fileidf.open(mdfFilename, std::ios::in);
    //std::stringstream tmp2;
    //tmp2<<fileidf.rdbuf();
    //mon_definition = tmp2.str();
    //fileidf.close();
    writeCharData(status, fileID, "instrument_bank_definition", det_definition);
    //writeCharData(status, fileID, "instrument_monitor_definition", mon_definition);

    NXclosegroup(fileID); //close csns
    NXclose(&fileID);
}

void ParserNXS::setLogs()
{
	cout<<"start set log!"<<endl;
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);

    status=NXopengroup(fileID,"csns","NXentry");
    status=NXopengroup(fileID,"logs", "NXcollection");
    setPCLog(status, fileID,pcfile);
    NXclosegroup(fileID);//close instrument
    NXclosegroup(fileID); //close csns
    NXclose(&fileID);
    cout<<"finish logs"<<endl;

}

void ParserNXS::setInstrument()
{
    ParserXML new_xml(sumfile);
    cout<<"============================="<<endl;    
    cout<<"start set instrument!"<<endl;
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);

    status=NXopengroup(fileID,"csns","NXentry");
    status=NXopengroup(fileID,"instrument","NXinstrument");
    
    std::map<std::string, std::string> moderatorInfo = new_xml.getModerator_SUM();
    setModerator(status, fileID, moderatorInfo);
    moderatorInfo.clear();
    
    std::map<std::string, std::string> sourceInfo = new_xml.getSource_SUM();
    setSource(status, fileID, sourceInfo);
    sourceInfo.clear();
 
    std::vector<std::map<std::string, std::string> > DCinfo = new_xml.getDC_SUM();
        setDC(status, fileID, DCinfo);
    DCinfo.clear();    
    
    std::vector<std::map<std::string, std::string> > SEinfo = new_xml.getSE_SUM();
        setSE(status, fileID, SEinfo);
    SEinfo.clear();    
    
    std::vector<std::map<std::string, std::string> > slitInfo = new_xml.getSlit_SUM();
    setAperture(status, fileID, slitInfo, "slitName", "NXslit");
    slitInfo.clear();    
    std::vector<std::map<std::string, std::string> > apertureInfo = new_xml.getAperture_SUM();
    setAperture(status, fileID, apertureInfo, "apertureName", "NXaperture");
    apertureInfo.clear();    

    std::map<std::string, std::string> sampleInfo = new_xml.getSample_SUM();
    setSample(status, fileID, sampleInfo);
    sampleInfo.clear();
    
    //CSNSgeometry sampleGeo_info = new_xml.getGeometry("NXsample");
    //setGeometry(status, fileID,"/csns/instrument/sample", sampleGeo_info);
    cout<<"start setBank"<<endl;
    setBank(status, fileID);
    setMonitor(status,fileID);

    NXclosegroup(fileID);//close instrument
    NXclosegroup(fileID); //close csns
    NXclose(&fileID);
    cout<<"finish instrument"<<endl;
}

void ParserNXS::setEventData()
{
   if (datatype.compare("event") == 0){
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    status=NXopengroup(fileID,"csns","NXentry");
    for(const auto &it : moduleList)
    {
        std::string name = it;
        NXlink eventPixelIdLink;
        NXlink eventPulseTimeLink;
        NXlink eventTimeOfFlightLink;
        string path ="/csns/instrument/"+name;
        string pathEventPixelId = path+"/event_pixel_id";
        string pathEventPulseTime = path+"/event_pulse_time";
        string pathEventTimeOfFlight = path+"/event_time_of_flight";
        string pathEventData="/csns/event_data";
        status=NXopenpath(fileID, pathEventPixelId.c_str());
        status=NXgetdataID(fileID, &eventPixelIdLink);
        status=NXopenpath(fileID, pathEventPulseTime.c_str());
        status=NXgetdataID(fileID, &eventPulseTimeLink);
        status=NXopenpath(fileID, pathEventTimeOfFlight.c_str());
        status=NXgetdataID(fileID, &eventTimeOfFlightLink);
        status=NXopenpath(fileID, pathEventData.c_str());

        writeGroup(status, fileID, name.c_str(), "NXevent_data");
        status=NXmakelink(fileID, &eventPixelIdLink);
        status=NXmakelink(fileID, &eventPulseTimeLink);
        status=NXmakelink(fileID, &eventTimeOfFlightLink);
        NXclosegroup(fileID);
        NXclosegroup(fileID);//close event
    }
    NXclosegroup(fileID);//close csns
    NXclose(&fileID);
   }
}
void ParserNXS::setHistData()
{
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    status=NXopengroup(fileID,"csns","NXentry");
    for(const auto &it : moduleList)
    {
        std::string name = it;
        string path ="/csns/instrument/"+name;
        NXlink HistTimeOfFlightLink;
        NXlink HistValueLink;
        string pathValue = path+"/histogram_data";
        string pathTimeOfFlight = path+"/time_of_flight";
        string pathHistData="/csns/histogram_data";
        status=NXopenpath(fileID, pathValue.c_str());
        status=NXgetdataID(fileID, &HistValueLink);
        status=NXopenpath(fileID, pathTimeOfFlight.c_str());
        status=NXgetdataID(fileID, &HistTimeOfFlightLink);
        status=NXopenpath(fileID, pathHistData.c_str());

        writeGroup(status, fileID, name.c_str(), "NXdata");
        status=NXmakelink(fileID, &HistValueLink);
        status=NXmakelink(fileID, &HistTimeOfFlightLink);
        NXclosegroup(fileID);
        NXclosegroup(fileID);//close hist
    }
    for(const auto &it : monitorFilelist)
    {
        std::string name = it.first;
        string path ="/csns/instrument/"+name;
        NXlink HistTimeOfFlightLink;
        NXlink HistValueLink;
        string pathValue = path+"/histogram_data";
        string pathTimeOfFlight = path+"/time_of_flight";
        string pathHistData="/csns/histogram_data";
        status=NXopenpath(fileID, pathValue.c_str());
        status=NXgetdataID(fileID, &HistValueLink);
        status=NXopenpath(fileID, pathTimeOfFlight.c_str());
        status=NXgetdataID(fileID, &HistTimeOfFlightLink);
        status=NXopenpath(fileID, pathHistData.c_str());

        writeGroup(status, fileID, name.c_str(), "NXdata");
        status=NXmakelink(fileID, &HistValueLink);
        status=NXmakelink(fileID, &HistTimeOfFlightLink);
        NXclosegroup(fileID);
        NXclosegroup(fileID);//close hist
    }

    NXclosegroup(fileID);//clsoe csns
    NXclose(&fileID);
}



/*
 * second-level group 
 * group-instrument
 * */

void ParserNXS::setModerator(NXstatus status, NXhandle fileID, const std::map<std::string, std::string>& info)
{
    bool judge = judgeMap(info);
    if(judge) 
    {
    int dim[1]={1};
    writeGroup(status, fileID, "moderator", "NXmoderator");
    writeCharData(status, fileID, "type", getStringFromMap(info,"type"));
    dim[0]=1;
    float tmp = getFloatFromMap(info,"distance");
    writeNumData(status, fileID, "distance", &tmp, 1, dim, "m");
    tmp = getFloatFromMap(info,"temperature");
    writeNumData(status, fileID, "temperature", &tmp, 1, dim, "K");
    NXclosegroup(fileID);
    }
}

void ParserNXS::setSource(NXstatus status, NXhandle fileID,  const std::map<std::string, std::string>& info)
{
    bool judge = judgeMap(info);
    if(judge)
    {
    int dim[1]={1};
    writeGroup(status, fileID, "source", "NXsource");
    writeCharData(status,fileID,"name",getStringFromMap(info,"name"));
    writeCharData(status,fileID,"type", getStringFromMap(info,"type"));
    writeCharData(status,fileID,"probe",getStringFromMap(info,"probe"));
    uint32_t tmp = getIntFromMap(info, "frequency");
    writeNumData(status, fileID, "frequency", &tmp, 1, dim, "Hz");
    float tmp2 =  getFloatFromMap(info,"power");
    writeNumData(status, fileID, "power", &tmp2, 1, dim, "W");
    NXclosegroup(fileID);
    }
}
/*
void ParserNXS::setGeometry(NXstatus status, NXhandle fileID, std::string path, CSNSgeometry info)
{
    int dim[1]={1};
    status=NXopenpath(fileID, path.c_str());
    writeGroup(status, fileID, "geometry", "NXgeometry");
    writeGroup(status, fileID, "shape", "NXshape");
    
    writeCharData(status, fileID, "shape", info.shape);
    if(0==strcmp(info.shape.c_str(),"nxcylinder"))
    {   dim[0] = 2;
    }else{
        dim[0] = 3;
    }
    writeNumData(status, fileID, "size", info.size.data(), 1, dim, "m");
    NXclosegroup(fileID);//close NXshape
    writeGroup(status, fileID, "orientation", "NXorientation");
    dim[0] = 6;
    writeNumData(status, fileID, "value", info.ori.data(), 1, dim, "");
    NXclosegroup(fileID);//close NXorientation
    writeGroup(status, fileID, "translation", "NXtranslation");
    dim[0] = 3;
    writeNumData(status, fileID, "distances", info.distances.data(), 1, dim, "");
    NXclosegroup(fileID);//close NXtranslation
    
    NXclosegroup(fileID);//close geometry
    NXclosegroup(fileID);//close upper
}
*/
void ParserNXS::setSample(NXstatus status, NXhandle fileID,  const std::map<std::string, std::string>& info)
{
    bool judge = judgeMap(info);
    if(judge)
    {
    int dim[1]={1};
    writeGroup(status, fileID, "sample", "NXsample");
    writeCharData(status,fileID,"name",getStringFromMap(info,"name"));
    writeCharData(status,fileID,"type", getStringFromMap(info,"type"));
    writeCharData(status,fileID,"situation",getStringFromMap(info,"situation"));
    writeCharData(status,fileID,"chemical_formular",getStringFromMap(info,"chemical_formular"));
    float tmp = getIntFromMap(info, "density");
    writeNumData(status, fileID, "density", &tmp, 1, dim, "Hz");
    tmp =  getFloatFromMap(info,"mass");
    writeNumData(status, fileID, "mass", &tmp, 1, dim, "W");
    NXclosegroup(fileID);
    }
}

void ParserNXS::setDC(NXstatus status, NXhandle fileID, const std::vector<std::map<std::string, std::string>>& info)
{
    bool judge = judgeVector(info);
    if(judge)
    {
    int dim[1]={1};
    float value = 0.0;
    for(auto it=info.begin();it!=info.end();it++)
    {
        map<string, string> tmp = *it;
        const string gName=getStringFromMap(tmp, "DCname");
        writeGroup(status, fileID, gName.c_str(), "NXdisk_chopper");
        value = getFloatFromMap(tmp, "phase");
        writeNumData(status, fileID, "phase", &value, 1, dim, "degree");
        value = getFloatFromMap(tmp, "slit_angle");
        writeNumData(status, fileID, "slit_angle", &value, 1, dim, "degree");
        value = getFloatFromMap(tmp, "rotation_speed");
        writeNumData(status, fileID, "rotation_speed", &value, 1, dim, "Hz");
        value = getFloatFromMap(tmp, "distance");
        writeNumData(status, fileID, "distance", &value, 1, dim, "m");
        tmp.clear();
        NXclosegroup(fileID);
    }
    }
}
void ParserNXS::setSE(NXstatus status, NXhandle fileID, const std::vector<std::map<std::string, std::string>>& info)
{
    bool judge = judgeVector(info);
    if(judge)
    {
    writeGroup(status, fileID, "sample_environment", "NXcollection");
    int dim[1] = {1};
    for(auto it=info.begin();it!=info.end();it++)
    {
        map<string, string> tmp = *it;
        coutMap(tmp); 
        const string gName=getStringFromMap(tmp, "SEname");
        writeGroup(status, fileID, gName.c_str(), "NXenvironment");
        writeCharData(status,fileID,"name",getStringFromMap(tmp,"name"));
        writeCharData(status,fileID,"type",getStringFromMap(tmp,"type"));
        NXclosegroup(fileID);
    }
    NXclosegroup(fileID);
    }
}
void ParserNXS::setAperture(NXstatus status, NXhandle fileID, const std::vector<std::map<std::string, std::string>>& info, const std::string & name, const std::string & typeName)
{
    bool judge = judgeVector(info);
    if(judge)
    {
    int dim[1]={1};
    float value = 0.0;
    for(auto it=info.begin();it!=info.end();it++)
    {
        std::map<std::string, std::string> tmp = *it;
        const std::string gName=getStringFromMap(tmp, name);
        writeGroup(status, fileID, gName.c_str(), typeName.c_str());
        value = getFloatFromMap(tmp, "xgap");
        writeNumData(status, fileID, "xgap", &value, 1, dim, "meter");
        value = getFloatFromMap(tmp, "ygap");
        writeNumData(status, fileID, "ygap", &value, 1, dim, "meter");
        tmp.clear();
        NXclosegroup(fileID);
    }
    }
}

void ParserNXS::setBank(NXstatus status, NXhandle fileID)
{
    ParserXML sum_xml(sumfile); 
    ParserXML idf_xml(idf_bank); 
    int dim[1]={1};
    int slab_start[2]={0,0};
    uint64_t evtNum=0;
    std::map<std::string, std::string> bankInfo = sum_xml.getBank_SUM();    
    delay_bank = getIntFromMap(bankInfo,"delay");
    std::string localName = getStringFromMap(bankInfo, "local_name");
    cout<<"local name: "<<localName<<endl;
    for(const auto &it : moduleList)
    {
        std::string moduleName = it;
	std::cout<<moduleName<<endl;
        writeGroup(status, fileID, moduleName.c_str(), "NXdetector");
        if(bl=="BL02")
        {
            std::string detMode = getStringFromMap(bankInfo, "detector_mode");
            float rotateAngle = getFloatFromMap(bankInfo, "rotate_angle");
            float distance = getFloatFromMap(bankInfo, "distance"); //unit is mm
            writeNumData(status, fileID, "rotate_angle", &rotateAngle, 1, dim, "degree");
            writeNumData(status, fileID, "distance", &distance, 1, dim, "mm");
            writeCharData(status, fileID, "detector_mode", detMode);
        }
        
	writeCharData(status, fileID, "local_name", localName);

        std::map<std::string, std::string> pidInfo = idf_xml.getPixels_IDF(moduleName);
        int xpid = getIntFromMap(pidInfo,"xpixels");
        int ypid = getIntFromMap(pidInfo,"ypixels");
	int pidNum = xpid*ypid;
        int idstart = getIntFromMap(pidInfo,"idstart");
        setPid(status, fileID, idstart, xpid, ypid);
        float xstep = getFloatFromMap(pidInfo, "xsize"); 
        float ystep = getFloatFromMap(pidInfo, "ysize"); 
        setPidSize(status, fileID, xstep, ystep, xpid, ypid);

        std::map<std::string, std::string> modulePos = idf_xml.getModulePos_IDF(moduleName);
        float xpos = getFloatFromMap(modulePos, "xpos"); 
        float ypos = getFloatFromMap(modulePos, "ypos"); 
        float zpos = getFloatFromMap(modulePos, "zpos"); 
        float rot = getFloatFromMap(modulePos, "rot"); 
        setCoordinate(status, fileID, xpos,ypos,zpos,xstep,ystep,rot,xpid, ypid); 
        setTof(status,fileID,timeStart_bank,timeBin_bank,timeStep_bank, delay_bank);        

	std::string daqfile = moduleFilelist[moduleName];
	//std::string daqfile = it.second;
	if(bl=="BL18")
	{    
	    setGPPDData(status, fileID, daqfile, pidNum, idstart);
	}
        if(bl=="BL01")
        {
		cout<<"start set daq data"<<endl;
	    try {setSANSData(status, fileID, pidNum,idstart, 1000.0, 6000.0); 
		}
	    catch(int e){
		    std::cout<<"catch(int)"<<e<<std::endl;
	    	
	    }
	}
        NXclosegroup(fileID);//close module
    }
    bankInfo.clear();
}

void ParserNXS::setMonitor(NXstatus status, NXhandle fileID)
{
    ParserXML sum_xml(sumfile); 
    ParserXML idf_xml(idf_monitor); 
    int dim[1]={1};
    int slab_start[2]={0,0};

    map<string, string> pcInfo = sum_xml.getPublic_SUM();
    
    float pcValue = getFloatFromMap(pcInfo,"proton_charge");
    cout<<"find pc: "<<pcValue<<endl;

    for(const auto &it : monitorFilelist)
    {
        std::string monitorName = it.first;
	cout<<"start with: "<<monitorName<<endl;
	status=NXmakegroup(fileID,monitorName.c_str(),"NXmonitor");
	status=NXopengroup(fileID,monitorName.c_str(),"NXmonitor");
        //writeGroup(status, fileID, monitorName.c_str(), "NXmonitor");
        std::map<std::string, std::string> monInfo = sum_xml.getMon_SUM(monitorName);
    	delay_monitor = getIntFromMap(monInfo,"delay");
    	std::string localName = getStringFromMap(monInfo, "local_name");
	writeCharData(status, fileID, "local_name", localName);

        setTof(status,fileID,timeStart_monitor,timeBin_monitor,timeStep_monitor, delay_monitor);        
	std::string monfile = it.second;
	cout<<"monitor file: "<<monfile<<endl;
	if(bl=="BL18"){
		int xpid = 32;
		int ypid = 32;
		int idstart = 1;
		setPid(status, fileID, idstart, xpid, ypid);
		setMonData(status, fileID, monfile,  1024, pcValue);
	}	
	if(bl=="BL01")
	{
		int xpid = 1;
		int ypid = 1;
		int idstart = 1;
		setPid(status, fileID, idstart, xpid, ypid);
		setMonData(status, fileID, monfile,  1, pcValue);
	}
        NXclosegroup(fileID);//close monitor
    }
}
/*
 * third-level group
 * */

void ParserNXS::setPid(NXstatus status, NXhandle fileID, int idstart, const int xpid, const int ypid)
{
    int dim2D[2]={ypid,xpid};
    vector<int64_t> pixelId;
    for (int i=0; i<xpid*ypid;i++){
        pixelId.push_back(idstart+i);
    }
    int slab_start[2]={0,0};
    int slab_size[2]={ypid, xpid};
    writeSlabData(status, fileID, "pixel_id", pixelId.data(), dim2D, slab_start, slab_size, "");
    pixelId.clear();
}

void ParserNXS::setCoordinate(NXstatus status, NXhandle fileID,float xpos, float ypos, float zpos, float xstep, float ystep, float rotValue, const int xpid, const int ypid)
{
    int dim2D[2]={ypid, xpid};
    std::vector<float> ra_distance;
    std::vector<float> az_angle;
    std::vector<float> po_angle;
    int num=0;
    for (int i=0; i<xpid; i++){
        for (int j=0; j<ypid;j++){
            float z = -sin(rotValue/180*M_PI)*(j*xstep)+zpos;
            float x = xpos +cos(rotValue/180*M_PI)*(j*xstep);
            float y = ypos+i*ystep;
            ra_distance.push_back(sqrt(x*x+y*y+z*z));
            az_angle.push_back(180/M_PI*acos(z/sqrt(x*x+y*y+z*z)));
            po_angle.push_back(180/M_PI*atan(y/x));
        }
    }
    int slab_start[2]={0,0};
    int slab_size[2]={ypid,xpid};
    writeSlabData(status, fileID, "radial_distance", ra_distance.data(), dim2D, slab_start, slab_size, "");
    writeSlabData(status, fileID, "polar_angle", po_angle.data(), dim2D, slab_start, slab_size, "");
    writeSlabData(status, fileID, "azimuthal_angle", az_angle.data(), dim2D, slab_start, slab_size, "");
    ra_distance.clear();
    po_angle.clear();
    az_angle.clear();
}

void ParserNXS::setPidSize(NXstatus status, NXhandle fileID, float xstep,float ystep, const int xpid, const int ypid)
{
    vector<float> x_pixel_size;
    vector<float> y_pixel_size;
    float z_pixel_size=0.0005;
    for(int i=0; i<xpid*ypid; i++){
        x_pixel_size.push_back(xstep);
        y_pixel_size.push_back(ystep);
    }
    int dim[1]={1};
    int dim2D[2]={ypid, xpid};
    int slab_start[2]={0,0};
    int slab_size[2]={ypid,xpid};
    writeSlabData(status, fileID, "x_pixel_size", x_pixel_size.data(), dim2D, slab_start, slab_size, "");
    writeSlabData(status, fileID, "y_pixel_size", y_pixel_size.data(), dim2D, slab_start, slab_size, "");
    writeNumData(status, fileID, "z_pixel_size", &z_pixel_size, 1, dim, "");
    x_pixel_size.clear();
    y_pixel_size.clear();
}

void ParserNXS::setTof(NXstatus status, NXhandle fileID,const int tStart, const int tBin, const int tStep, const uint32_t delay)
{
    int dim[1]={0};
    vector<uint32_t> tof;
    int tDelay=0;
    if(delay>1)
        tDelay = delay;
    //cout<<"setTof: "<<tStart<<"||"<<tStep<<"||"<<tDelay<<endl;
    for(uint32_t i=0; i<tBin; i++)
        tof.push_back(tStart+tDelay+i*tStep);
    dim[0]=tBin;
    writeNumData(status, fileID, "time_of_flight", tof.data(), 1, dim, "");
    dim[0]=1;
    writeNumData(status, fileID, "delay", &delay, 1, dim, "us");
    tof.clear();
}

void ParserNXS::setMonData(NXstatus status, NXhandle fileID, std::string filename,  const int pidNum, const float pc)
{
        std::vector<uint32_t> histData;
    	int a=0;
    if (filename==""){
	for(int i=0; i<pidNum; i++){
           for(int j=0; j<timeBin_monitor-1; j++){
		histData.push_back(0);
	   }
        }
            cout<<"no such file "<<endl;
    }else{
    	std::ifstream histfile(filename.c_str(), ios::binary);
    	uint32_t** buffer = new uint32_t* [pidNum];
    	if(histfile.is_open())
    	{
        	histfile.seekg(0, histfile.end);
        	histfile.seekg(0, histfile.beg);
        	for(int i = 0; i< pidNum; i++){
            		buffer[i] = new uint32_t [timeBin_monitor-1];
            		histfile.read((char*)buffer[i],(timeBin_monitor-1)*sizeof(uint32_t));
        	}
        	histfile.close();
        	uint64_t n = 0;
        	for(int i=0; i<pidNum; i++){
            		for(int j=0; j<timeBin_monitor-1; j++){
                	a+=buffer[i][j];
                histData.push_back(buffer[i][j]);
                n++;
            	}
        	}
            cout<<"total neutron counts: "<<a<<endl;
        }
    }
	int slab_size[2]={pidNum,(timeBin_monitor-1)};
        int slab_start[2]={0,0};
        int dim2D[2]={pidNum, timeBin_monitor-1};
        writeSlabData(status, fileID, "histogram_data",histData.data(), dim2D, slab_start, slab_size, "");
        histData.clear();

	if (pc>0)
	{
	 int dim[1]={1};
	float rt = float(a)/pc;
	writeNumData(status, fileID, "m_pc", &rt, 1, dim, "");
	}
}
void ParserNXS::setPCLog(NXstatus status, NXhandle fileID, std::string filename)
{
	FILE *fp=fopen(filename.c_str(),"r");
        int tai;
        float pc,tmp;
        std::vector<int64_t> taiList;
        std::vector<float> pcList;
        while(!feof(fp))
        {
                fscanf(fp,"%d%f%f", &tai,&tmp, &pc);
                taiList.push_back(tai);
                pcList.push_back(pc);
        }
        taiList.pop_back();
        pcList.pop_back();

	/*
	double t,p;
	uint64_t tai;
	std::vector<double> pcList;
	ifstream infile;
	infile.open(filename,ios::in);
	if(!infile.is_open())
		std::cout<<"open file failure"<<std::endl;
	int nlines=0;
	while (!infile.eof())
	{
		//infile>>tai>>p;
		infile>>t>>p;
		//taiList.push_back(tai);
		pcList.push_back(t);
		pcList.push_back(p);
		nlines++;
	}
	infile.close();
	
	int slab_size[2]={nlines,2};
        int slab_start[2]={0,0};
        int dim2D[2]={nlines, 2};
        writeSlabData(status, fileID, "proton_charge",pcList.data(), dim2D, slab_start, slab_size, "");
	*/
	
	//uint64_t evtNum = pidList.size();
    	int dim[1]={1};
    	dim[0]=taiList.size();
        writeNumData(status, fileID, "utc_tai", taiList.data(), 1, dim, "");
        writeNumData(status, fileID, "proton_charge", pcList.data(), 1, dim, "");
	
	pcList.clear();
	taiList.clear();
}

void ParserNXS::setGPPDData(NXstatus status, NXhandle fileID, std::string filename,  const int pidNum, const int pidStart)
{
    FileReader reader(filename);
    cout<<filename<<endl;
    std::vector<uint8_t> data;
    reader.readAll(data);
    const uint8_t * buffer = data.data();
    const size_t length = reader.fileLength();
    auto *pmt = new Parser::PMTParser();
    std::vector<Parser::HitInfo> hitinfo;
    unsigned loop=0, event_cnt = 0;
    NumpyHist2D hist2(timeBin_bank-1, timeStart_bank, timeEnd_bank, float(pidNum), 0.-0.5, float(pidNum)-0.5);
	//cout<<"time set: "<<timeBin_bank-1<<"++"<<timeStart_bank<<"++"<<timeEnd_bank<<endl;
	//cout<<"pid set: "<<pidNum<<"++"<<-0.5<<"++"<<float(pidNum)<<endl;
    std::vector<uint64_t> pidList;
    std::vector<float> tofList;
    std::vector<uint64_t> pulseList;
    //double digit2us = 1./40;
      const uint8_t * abuf = buffer;
      while(pmt->extractNextPackage(abuf, buffer+length, hitinfo))
      {
        loop++;
        event_cnt+=hitinfo.size();
        for(auto v: hitinfo)
        {
          unsigned pid = pmt->getPixelID((int)v.pos, (int)v.posy, true);
	  //cout<<"get raw pid "<<pid<<endl;
    if (datatype.compare("event") == 0){
	  pidList.push_back(pid);
	  tofList.push_back(v.t/40);
	  pulseList.push_back(v.hit_t0);}
          hist2.fill( (int)(v.t/40), pid-pidStart);
        }
      }
    if (datatype.compare("event") == 0){
    uint64_t evtNum = pidList.size();
    int dim[1]={1};
    dim[0]=evtNum;
        cout<<"evt num : "<<evtNum<<endl;
        writeNumData(status, fileID, "event_pixel_id", pidList.data(), 1, dim, "");
        writeNumData(status, fileID, "event_time_of_flight", tofList.data(), 1, dim, "");
        writeNumData(status, fileID, "event_pulse_time", pulseList.data(), 1, dim, "");}
        pidList.clear();
        tofList.clear();
        pulseList.clear();

        auto tmp2 = hist2.getRaw();
        std::vector<uint32_t> histData;
        //std::copy(tmp2.cbegin(), tmp2.cend(), histData.begin()); valgrind has error
        std::copy(tmp2.cbegin(), tmp2.cend(), std::back_inserter(histData));
        int slab_size[2]={pidNum,(timeBin_bank-1)};
	int slab_start[2]={0,0};
        int dim2D[2]={pidNum, timeBin_bank-1};
        writeSlabData(status, fileID, "histogram_data",histData.data(), dim2D, slab_start, slab_size, "");
	histData.clear();
        cout<<"finish parser : "<<filename<<endl;
}


