#ifndef Histogram_Hist2DMap_hh
#define Histogram_Hist2DMap_hh

#include <map>
#include <vector>
#include <mutex>

#include "NumpyHist2D.hh"

// This class reads information from a full package.
  class Hist2DMap {
  public:
    Hist2DMap(unsigned nbinsx, double xmin, double xmax,
           unsigned nbinsy, double ymin, double ymax);
    virtual ~Hist2DMap();

    inline void fill(unsigned key, double x, double y);
    void reset();
    std::map<unsigned, NumpyHist2D* >::const_iterator getHistMapBegin() const;
    std::map<unsigned, NumpyHist2D* >::const_iterator getHistMapEnd() const;

  private:
    std::mutex m_histmap_mutex;
    std::map<unsigned, NumpyHist2D* > m_histmap;
    unsigned m_xbin;
    double m_xl, m_xu;
    unsigned m_ybin;
    double m_yl, m_yu;
  };



inline void Hist2DMap::fill(unsigned key, double x, double y)
{
  // Lock The Data structure
  std::lock_guard<std::mutex> guard(m_histmap_mutex);

  auto it_hist = m_histmap.find(key);
  NumpyHist2D *histpt;
  //create a new histogram for a new key
  if(it_hist==m_histmap.end()) {
    histpt = new NumpyHist2D(m_xbin, m_xl, m_xu, m_ybin, m_yl, m_yu);
    m_histmap[key] = histpt;
  }
  else
    histpt = it_hist->second;

  histpt->fill(x,y);
}
#endif
