#include "NumpyHist2D.hh"
#include <cmath>
#include <vector>
#include <iostream>

NumpyHist2D::NumpyHist2D(unsigned xnbins, double xmin, double xmax,
                         unsigned ynbins, double ymin, double ymax)
:NumpyHistBase(xnbins*ynbins), m_xbinfactor(xnbins/(xmax-xmin)),
m_ybinfactor(ynbins/(ymax-ymin))
{
  m_xmin=xmin, m_xmax=xmax, m_xnbins=xnbins;
  m_ymin=ymin, m_ymax=ymax, m_ynbins=ynbins;
  m_nbins = m_xnbins * m_ynbins;

  // std::invalid_argument("data can not be shaped by the given shape vector");

}

NumpyHist2D::~NumpyHist2D()
{
}

void NumpyHist2D::serialise(std::string &serialised) const
{
  std::lock_guard<std::mutex> guard(m_hist_mutex);

  serialise_numpy(std::vector<uint64_t>{m_xnbins, m_ynbins}, serialised);
}

//Normal filling:
void NumpyHist2D::fill(double xval, double yval)
{
  std::lock_guard<std::mutex> guard(m_hist_mutex);

  if(xval<m_xmin ||  yval<m_ymin) {
    m_underflow++;
    return;
  }
  else if(xval>m_xmax || yval>m_ymax) {
    m_overflow++;
    return;
  }
  unsigned ix = floor((xval-m_xmin)*m_xbinfactor);
  unsigned iy = floor((yval-m_ymin)*m_ybinfactor);
  ++m_data[ix*m_ynbins + iy];
}

void NumpyHist2D::fill(double xval, double yval, double w)
{
  std::lock_guard<std::mutex> guard(m_hist_mutex);

  if(xval<m_xmin ||  yval<m_ymin) {
    m_underflow+=w;
    return;
  }
  else if(xval>m_xmax || yval>m_ymax) {
    m_overflow+=w;
    return;
  }
  unsigned ix = floor((xval-m_xmin)*m_xbinfactor);
  unsigned iy = floor((yval-m_ymin)*m_ybinfactor);
  m_data[iy*m_xnbins + ix]+=w;
}
