#include <dic.hxx>
#include <iostream>
#include <vector>
#include <string>
#include <fstream>
#include <memory>
#include "DAQInterface.hh"
#include "Hist2DMap.hh"
#include "RedisIO.hh"
#include "Earthworm.hh"
#include "RedisNumpy.hh"

int main()
{
	std::cout << "Starting client..." << std::endl;
  unsigned pid_num(1200), tof_num(2500);

	std::shared_ptr<RedisIO> redis(
		new RedisIO("10.1.31.116", 9001, "neonmaster", "sanlie;123"));
  //redis should retrive all parameters
  std::shared_ptr<Hist2DMap> histmap(new Hist2DMap(tof_num, 0 , 400000, pid_num, 0,150) );

  //RunNumber runNumber;
	DAQInterface daq("sim/dimserver/TEST_SWAP_1",1000);
	daq.setActiveStatus(true);
  daq.setHist2DMap(histmap);

	std::vector<double> pid;
	for(unsigned i=0;i<pid_num;i++)
	  pid.push_back(i+1);
	RedisNumpy nvt;
  std::string pidstr;
	std::vector<uint64_t> shape;
	shape.push_back(pid_num);
	nvt.makeNumpyArr(pid, RedisNumpy::data_type::f8,
									 shape, pidstr);
	redis->writeString("/sim/MR/workspace/detector/module1/pid", pidstr);

	std::vector<double> tof;
	for(unsigned i=0;i<tof_num+1;i++)
	{
		tof.push_back(i*16);
	}
	std::string tofstr;
	shape[0]=(tof_num+1);
	nvt.makeNumpyArr(tof, RedisNumpy::data_type::f8,
									 shape, tofstr);
	redis->writeString("/sim/MR/workspace/detector/module1/tof", tofstr);

	//while(1)
	{
		std::this_thread::sleep_for(std::chrono::milliseconds(1000));

    std::string str;
		histmap->merge(str);
		redis->writeString("/sim/MR/workspace/detector/module1/value", str);

		// histmap->makeNumpyRaw(str, std::vector<unsigned>{7, 8, 9, 11});
		// redis->writeString("/sim/MR/workspace/detector/module1/value", str);


		// histmap->makeNumpyXSum(str, std::vector<unsigned>{7, 8, 9, 11});
		// redis->writeString("/sim/MR/workspace/detector/module1/pid", str);

		// histmap->makeNumpyYSum(str, std::vector<unsigned>{7, 8, 9, 11});
		// redis->writeString("/sim/MR/workspace/detector/module1/tof", str);


		// histmap->makeNumpyRaw(str, std::vector<unsigned>{7, 8, 9, 11});
		// std::ofstream outfile("full.npy", std::ofstream::trunc|std::ofstream::binary);
		// outfile << str;
		// outfile.close();
		//
		// histmap->makeNumpyXSum(str, std::vector<unsigned>{4, 7, 8, 10});
		// std::ofstream outfile2("TOF.npy", std::ofstream::trunc|std::ofstream::binary);
		// outfile2 << str;
		// outfile2.close();
		//
		// histmap->makeNumpyYSum(str, std::vector<unsigned>{4, 7, 8, 10});
		// std::ofstream outfile3("POS.npy", std::ofstream::trunc|std::ofstream::binary);
		// outfile3 << str;
		// outfile3.close();

	}


	// std::this_thread::sleep_for(std::chrono::milliseconds(100));
  return 0;
}
