#include <iostream>
#include <vector>
#include <string>
#include <fstream>

#include <nlohmann/json.hpp>

// for convenience
using json = nlohmann::json;

int main()
{

  std::ifstream f("test.json");
  json j;
  f >> j;

  // iterate the array
  for (json::iterator it = j.begin(); it != j.end(); ++it) {
    if(!it->is_object())
    {
      std::cout << it.key() << " : " << it.value() << "\n";
    }
    else
    {
      std::cout << "object size : " << it->size() << "\n";
      for (json::iterator it_lv2 = it->begin(); it_lv2 != it->end(); ++it_lv2)
      {
        std::cout << it_lv2.key() << " : " << it_lv2.value() << "\n";
      }
    }
  }

  // other stuff
  j.size();     // 3 entries
  j.empty();    // false
  j.type();     // json::value_t::array
  //j.clear();    // the array is empty again

  // convenience type checkers
  j.is_null();
  j.is_boolean();
  j.is_number();
  j.is_object();
  j.is_array();
  j.is_string();

  // find an entry
  if (j.find("foo") != j.end()) {
    // there is an entry with key "foo"
  }

  // or simpler using count()
  int foo_present = j.count("foo"); // 1
  int fob_present = j.count("fob"); // 0

  // delete an entry
  j.erase("foo");


  return 0;
}
