#!/usr/bin/python

from __future__ import print_function
import vacf
import time
import sys
import h5py
import numpy as np
from xlib import *


radpsec2meV =  6.5821e-13
radpfs2meV = radpsec2meV*1e15

fname = 'dump_h5md.h5'
if len(sys.argv)==2:
    fname = sys.argv[1]

trj = Trajectory(fname)


tasks = [['hh',1,1],
        ['oo',2,2],
        ['ho',1,2]]

f = h5py.File('mdana.hdf5','w')


timeStep=np.arange(0,trj.nFrame//2, 2,dtype=np.uint32)
Q=np.logspace(-1,1.6,30)

for atask in tasks:
    print('performing task',atask[0] )
    start_time = time.time()
    cvv = trj.cvv(atask[1],atask[2])
    ftq=trj.intermediate( atask[1],atask[2],  Q, timeStep)
    grp=f.create_group(atask[0])
    grp['cvv'] = cvv
    grp['ftq'] = ftq
    grp['deltaTfs'] = trj.deltaTfs
    grp['Q'] = Q
    grp['t'] = timeStep*trj.deltaTfs
    print  ('time ' , time.time() - start_time, 's')

f.close()
