#include <iostream>
#include  <memory> // We need to include this for shared_ptr
#include <mutex>
#include <future>
#include <chrono>
#include "Earthworm.hh"

class Mtobj {
public:
  Mtobj():m_cnt(0){}
  ~Mtobj(){EW_LOG_INFO("Deconstructing");}
  void incmet() {
    std::lock_guard<std::mutex> guard(m_mtobj_mutex);
    std::this_thread::sleep_for(std::chrono::milliseconds(10));
    m_cnt++;
  }
  void show(){EW_LOG_INFO("m_cnt is {}", m_cnt);}
private:
  unsigned m_cnt;
  mutable std::mutex m_mtobj_mutex;
};

int main()
{
  // Creating a shared_ptr through make_shared
  std::shared_ptr<Mtobj> p1(new Mtobj());
  p1->show();

  for(unsigned i=0;i<100;i++)
  {
    std::shared_ptr<Mtobj> p2(p1);
    std::async(std::launch::async, &Mtobj::incmet, p2);
    p1->show();
    EW_LOG_INFO("Ref count {}", p1.use_count());
  }
  EW_LOG_INFO("Done! Ref count {}", p1.use_count());

  p1.reset(new Mtobj);
  std::cout << "p1  Reference Count = " << p1.use_count() << std::endl;

  return 0;
}
