#!/usr/bin/env python

from __future__ import print_function   # makes this work for python2 and 3


import numpy as np
import matplotlib.pyplot as plt

hist_charge = np.loadtxt('hist_charge.txt')
plt.plot(hist_charge[:,0],hist_charge[:,1])
fullpeak = 11800.
plt.plot([fullpeak,fullpeak],[0,np.max(hist_charge[:,1])*1.2],label='full peak')
plt.plot([fullpeak*.75,fullpeak*.75],[0,np.max(hist_charge[:,1])*1.2],label='75% full peak')
plt.plot([fullpeak*.25,fullpeak*.25],[0,np.max(hist_charge[:,1])*1.2],label='25% full peak')
plt.title('charge distribution')
plt.legend()

plt.figure()
hist_pos= np.loadtxt('hist_pos.txt')
plt.plot(hist_pos[:,0],hist_pos[:,1])
plt.title('position distribution')

plt.figure()
hist_tof= np.loadtxt('hist_tof.txt')
plt.plot(hist_tof[:,0],hist_tof[:,1])
plt.title('TOF')


plt.show()
