import numpy as np
import matplotlib.pyplot as plt
import matplotlib.colors as colors

data=np.loadtxt('Hist2D.txt')
rdata=data.reshape(2500,1200)

y=np.linspace(0,40000,2500)
x=np.linspace(0,300,1200)

xx, yy = np.meshgrid( x,y)
fig, (ax0) = plt.subplots(nrows=1)
im = ax0.pcolormesh(xx,yy, rdata,
                    norm=colors.LogNorm(vmin=rdata.min()+1e-10, vmax=rdata.max()),
                   cmap='PuBu_r')
plt.show()