
import numpy as np
import matplotlib.pyplot as plt

data=np.loadtxt('mwpc_dec.dat',dtype='int')

event=345267 #203934 of them have both wire and pad value
epool={}
temp=[]
idx = 0
for line in data:
   if line[0] == idx:
       temp.append(line[1:])
   else:
       epool[idx]=np.asarray(temp)
       temp=[]
       temp.append(line[1:])
       idx = line[0]

evtQ = []
for k, v in epool.items():
    evtQ.append(v[:,2].sum())

evtQ=np.array(evtQ, dtype='int')
#plt.hist(evtQ,1000)

bigEntIdx =np.array(np.where(evtQ>3500))[0]


idx = epool[bigEntIdx[0]][:,1]

# analysis
x=[]
y=[]
t=[]
for k, v in epool.items():
    xmean_vec =  v[np.where(v[:,1] < 51)][:,1]
    # print (xmean_vec)
    if len(xmean_vec)== 0:
        continue
    else:
        xmean=xmean_vec.mean()
    ymean_vec =  v[np.where(v[:,1] >= 51)][:,1]
    # print (xmean_vec)
    if len(ymean_vec)== 0:
        continue
    else:
        ymean=ymean_vec.mean()-50

    x.append(xmean)
    y.append(ymean)
    t.append(v[0,0])

x=np.array(x)
y=np.array(y)
t=np.array(t)

from mpl_toolkits.mplot3d import axes3d
fig=plt.figure()
ax = fig.gca(projection='3d')
colors = ("red", "green", "blue")

ax.scatter(x, y, t, alpha=0.1, edgecolors='none')
plt.show()
