#include <cpp_redis/cpp_redis>
#include <iostream>
#include <stdio.h>
#include "RedisHelper.hh"

// this example writes an incremental double array to a Redis storage and read back.
int main(void) {
  //! Enable logging
  cpp_redis::active_logger = std::unique_ptr<cpp_redis::logger>(new cpp_redis::logger);

  //! High availability requires at least 2 io service workers
  cpp_redis::network::set_default_nb_workers(2);

  cpp_redis::client client;

  //! Add your sentinels by IP/Host & Port
  client.add_sentinel("10.1.31.116", 9001);


  //! Call connect with optional timeout
  //! Can put a loop around this until is_connected() returns true.
  client.connect("neonmaster", [](const std::string& host, std::size_t port, cpp_redis::connect_state status) {
    if (status == cpp_redis::connect_state::dropped) {
      std::cout << "client disconnected from " << host << ":" << port << std::endl;
    }
  },
    0, -1, 5000);

  client.auth("sanlie;123", [](const cpp_redis::reply& reply) {
  if (reply.is_error()) { std::cerr << "Authentication failed: " << reply.as_string() << std::endl; }
  else {
    std::cout << "successful authentication" << std::endl;
  }
 });

  // same as client.send({ "SET", "hello", "42" }, ...)

  std::vector<double> data;
  unsigned sz = 20;
  data.reserve(sz);
  for(unsigned i=0;i<sz;i++)
    data.push_back(i);

  // std::string encoded;
  // // std::cout << "encoded as " << encoded << std::endl;
  //
  // auto start = std::chrono::system_clock::now();
  // unsigned loopnum = 1;
  // double tot_time = 0.;
  // for(unsigned i=0;i<loopnum;i++)
  // {
  //   c2json_uint8(data.data(), std::vector<unsigned>{sz}, encoded);
  //   auto now = std::chrono::system_clock::now();
  //   std::chrono::duration<double> elapsed_seconds = now - start;
  //   tot_time += elapsed_seconds.count();
  //   start = now;
  // }
  // std::cout << "C++ average encoding speed "
  //  << data.size()*sizeof(uint32_t)/1024./1024/(tot_time/loopnum) << " MB/seconds" <<std::endl;

  uint8_t* raw = reinterpret_cast<uint8_t*>(data.data());
  std::string astr(raw, raw+sz*sizeof(double) );

  client.set("/XX/dont/touch/me", astr, [](cpp_redis::reply& reply) {
    //std::cout << "/XX/dont/touch/me: " << reply << std::endl;

    // if (reply.is_string())
    //   do_something_with_string(reply.as_string())
  });
  // synchronous commit, no timeout
  client.sync_commit();

  client.get("/XX/dont/touch/me", [sz](cpp_redis::reply& reply) {
    if(reply.is_array())
      std::cout << "is_array" << std::endl;
    if(reply.is_bulk_string())
      std::cout << "is_bulk_string" << std::endl;
    if(reply.is_error())
      std::cout << "is_error" << std::endl;
    if(reply.is_simple_string ())
      std::cout << "is_simple_string (" << std::endl;
    if(reply.is_integer  () )
      std::cout << "is_integer  (" << std::endl;
    if(reply.is_null  ())
      std::cout << "is_null  (" << std::endl;

    const std::string & fromredis = reply.as_string();
    const double *uintarr = reinterpret_cast<const double *>(fromredis.data());
    for(unsigned i=0;i<sz;i++)
      printf("%f\n",*(uintarr+i) );

    std::cout << "Kindely replied." << std::endl;

    // if (reply.is_string())
    //   do_something_with_string(reply.as_string())
  });
  client.sync_commit();

  // synchronous commit, no timeout

  std::cout << std::endl;
  // std::this_thread::sleep_for(std::chrono::milliseconds(10));

  return 0;
}
