#include <cstring>

#include "prototype.h"
#include "UtilsException.hh"
#include "ParserBase.hh"

static int quietonerror = 0;
static int haltonerror = 1;
static int waserror = 0;
static char errmsg[512];
static char errtype[64];
static void (*custom_error_handler)(char *,char*) = 0;

/*
int ncrystal_error()
{
  return waserror;
}

void setError(const char *msg, const char * etype = 0) throw() {
  if (!etype)
    etype="ncrystal_c-interface";
  strncpy(errmsg,msg,sizeof(errmsg));
  strncpy(errtype,etype,sizeof(errtype));
  //Ensure final null-char in case of very long input strings:
  errmsg[sizeof(errmsg)-1]='\0';
  errtype[sizeof(errtype)-1]='\0';
  if (custom_error_handler) {
    (*custom_error_handler)(errtype,errmsg);
  }
  waserror = 1;
  if (!quietonerror)
    printf("ERROR [%s]: %s\n",errtype,errmsg);
  if (haltonerror) {
    printf("Terminating due to ERROR\n");
    exit(1);
  }
}

void handleError(const std::exception &e) throw() {
  const Error::Exception* nce = dynamic_cast<const Error::Exception*>(&e);
  if (nce) {
    setError(nce->what(),nce->getTypeName());
    return;
  }
  const std::runtime_error* stdrte = dynamic_cast<const std::runtime_error*>(&e);
  if (stdrte)
    setError(stdrte->what(),"std::runtime_error");
  else
    setError("<unknown>","std::exception");
}

#define ERRCATCH catch (std::exception& e) { handleError(e); }

Parser::ParserBase * extract_detectorbase(Parser_Parserbase_t o) {
  error_assert(o.internal);
  return reinterpret_cast<Parser::ParserBase*>(o.internal);
}

Parser_Parserbase_t create_detectorbase()
{
  Parser_Parserbase_t o;
  o.internal = 0;
  try {
    const Parser::ParserBase * db = new Parser::ParserBase();
    error_assert(db);
    o.internal = (void*)db;
  } ERRCATCH;
  return o;
}


void Parser_read_uint32( Parser_Parserbase_t ci_t, const uint8_t* it , uint32_t *u32)
{
  // if (!ncrystal_valid(&ci_t)) {
  //   ncc::setError("ncrystal_info_dspacing_from_hkl called with invalid crystal info object");
  //   return 0.0;
  // }
  // try {
    Parser::ParserBase * ci = extract_detectorbase(ci_t);
    ci->read_uint32(it, *u32);
  //} ERRCATCH;
  //return 0.0;
}

*/
