#include "RedisHelper.hh"
#include "UtilsException.hh"
#include <iostream>

static const std::string base64_chars =
             "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
             "abcdefghijklmnopqrstuvwxyz"
             "0123456789+/";


void base64_encode(unsigned char const *bytes_to_encode, unsigned int in_len, std::string &ret)
{
  int i = 0;
  int j = 0;
  unsigned char char_array_3[3];
  unsigned char char_array_4[4];

  while (in_len--) {
    char_array_3[i++] = *(bytes_to_encode++);
    if (i == 3) {
      char_array_4[0] = (char_array_3[0] & 0xfc) >> 2;
      char_array_4[1] = ((char_array_3[0] & 0x03) << 4) + ((char_array_3[1] & 0xf0) >> 4);
      char_array_4[2] = ((char_array_3[1] & 0x0f) << 2) + ((char_array_3[2] & 0xc0) >> 6);
      char_array_4[3] = char_array_3[2] & 0x3f;

      for(i = 0; (i <4) ; i++)
        ret += base64_chars[char_array_4[i]];
      i = 0;
    }
  }

  if (i)
  {
    for(j = i; j < 3; j++)
      char_array_3[j] = '\0';

    char_array_4[0] = ( char_array_3[0] & 0xfc) >> 2;
    char_array_4[1] = ((char_array_3[0] & 0x03) << 4) + ((char_array_3[1] & 0xf0) >> 4);
    char_array_4[2] = ((char_array_3[1] & 0x0f) << 2) + ((char_array_3[2] & 0xc0) >> 6);

    for (j = 0; (j < i + 1); j++)
      ret += base64_chars[char_array_4[j]];

    while((i++ < 3))
      ret += '=';

  }

}

void base64_decode(std::string const& encoded_string, std::string &ret)
{
  size_t in_len = encoded_string.size();
  int i = 0;
  int j = 0;
  int in_ = 0;
  unsigned char char_array_4[4], char_array_3[3];

  while (in_len-- && ( encoded_string[in_] != '=') && is_base64(encoded_string[in_])) {
    char_array_4[i++] = encoded_string[in_]; in_++;
    if (i ==4) {
      for (i = 0; i <4; i++)
        char_array_4[i] = base64_chars.find(char_array_4[i]) & 0xff;

      char_array_3[0] = ( char_array_4[0] << 2       ) + ((char_array_4[1] & 0x30) >> 4);
      char_array_3[1] = ((char_array_4[1] & 0xf) << 4) + ((char_array_4[2] & 0x3c) >> 2);
      char_array_3[2] = ((char_array_4[2] & 0x3) << 6) +   char_array_4[3];

      for (i = 0; (i < 3); i++)
        ret += char_array_3[i];
      i = 0;
    }
  }

  if (i) {
    for (j = 0; j < i; j++)
      char_array_4[j] = base64_chars.find(char_array_4[j]) & 0xff;

    char_array_3[0] = (char_array_4[0] << 2) + ((char_array_4[1] & 0x30) >> 4);
    char_array_3[1] = ((char_array_4[1] & 0xf) << 4) + ((char_array_4[2] & 0x3c) >> 2);

    for (j = 0; (j < i - 1); j++) ret += char_array_3[j];
  }
}

void make_jsonarray(unsigned char const * data, unsigned len, const std::string &dtype,
                    const std::vector<unsigned> &shape, std::string &encoded)
{
  encoded = "{\"dtype\": \"" + dtype;
  encoded.reserve(len*2);

  encoded += "\", \"shape\": [";
  error_assert_always(!shape.empty());
  unsigned lastid = shape.size()-1;
  for(unsigned i=0;i<lastid;i++)
  {
    encoded += std::to_string(shape[i])+", ";
  }
  encoded += std::to_string(shape[lastid]);

  encoded += "], \"__ndarray__\": \"";
  base64_encode(reinterpret_cast<const unsigned char*> ( data ), len, encoded);
  encoded += "\"}";
}

void c2json_int8(const int8_t *data, const std::vector<unsigned>& shape, std::string &encoded)
{
  unsigned len=1;
  for(auto v:shape)
    len *= v;
  make_jsonarray(reinterpret_cast<const unsigned char*> ( data ), len*sizeof(int8_t), "int8",
                 shape, encoded);
}

void c2json_uint8(const uint8_t *data, const std::vector<unsigned>& shape, std::string &encoded)
{
  unsigned len=1;
  for(auto v:shape)
    len *= v;
  make_jsonarray(reinterpret_cast<const unsigned char*> ( data ), len*sizeof(uint8_t), "uint8",
                 shape, encoded);
}

void c2json_int16(const int16_t *data, const std::vector<unsigned>& shape, std::string &encoded)
{
  unsigned len=1;
  for(auto v:shape)
    len *= v;
  make_jsonarray(reinterpret_cast<const unsigned char*> ( data ), len*sizeof(int16_t), "int16",
                 shape, encoded);
}

void c2json_uint16(const uint16_t *data, const std::vector<unsigned>& shape, std::string &encoded)
{
  unsigned len=1;
  for(auto v:shape)
    len *= v;
  make_jsonarray(reinterpret_cast<const unsigned char*> ( data ), len*sizeof(uint16_t), "uint16",
                 shape, encoded);
}


void c2json_int32(const int32_t *data, const std::vector<unsigned>& shape, std::string &encoded)
{
  unsigned len=1;
  for(auto v:shape)
    len *= v;
  make_jsonarray(reinterpret_cast<const unsigned char*> ( data ), len*sizeof(int32_t), "int32",
                 shape, encoded);
}

void c2json_uint32(const uint32_t *data, const std::vector<unsigned>& shape, std::string &encoded)
{
  unsigned len=1;
  for(auto v:shape)
    len *= v;
  make_jsonarray(reinterpret_cast<const unsigned char*> ( data ), len*sizeof(uint32_t), "uint32",
                 shape, encoded);
}

void c2json_int64(const int64_t *data, const std::vector<unsigned>& shape, std::string &encoded)
{
  unsigned len=1;
  for(auto v:shape)
    len *= v;
  make_jsonarray(reinterpret_cast<const unsigned char*> ( data ), len*sizeof(int64_t), "int64",
                 shape, encoded);
}

void c2json_uint64(const uint64_t *data, const std::vector<unsigned>& shape, std::string &encoded)
{
  unsigned len=1;
  for(auto v:shape)
    len *= v;
  make_jsonarray(reinterpret_cast<const unsigned char*> ( data ), len*sizeof(uint64_t), "uint64",
                 shape, encoded);
}

void c2json_float(const float *data, const std::vector<unsigned>& shape, std::string &encoded)
{
  unsigned len=1;
  for(auto v:shape)
    len *= v;
  make_jsonarray(reinterpret_cast<const unsigned char*> ( data ), len*sizeof(float), "float32",
                 shape, encoded);
}

void c2json_double(const double *data, const std::vector<unsigned>& shape, std::string &encoded)
{
  unsigned len=1;
  for(auto v:shape)
    len *= v;
  make_jsonarray(reinterpret_cast<const unsigned char*> ( data ), len*sizeof(double), "float64",
                 shape, encoded);
}
