#ifndef RedisHelper_hh
#define RedisHelper_hh

#include <string>
#include <vector>
#include <typeinfo>

static inline bool is_base64(unsigned char c) {
  return (isalnum(c) || (c == '+') || (c == '/'));
}

void base64_encode(unsigned char const * , unsigned int len, std::string &encoded);
void base64_decode(std::string const &encoded_string, std::string &decoded);

//content in the encoded will be replaced by new data
void make_jsonarray(unsigned char const * data, unsigned len, const std::string &dtype,
                    const std::vector<unsigned> &shape, std::string &encoded);

void c2json_int8(const int8_t *data, const std::vector<unsigned>& shape, std::string &encoded);
void c2json_uint8(const uint8_t *data, const std::vector<unsigned>& shape, std::string &encoded);

void c2json_int16(const int16_t *data, const std::vector<unsigned>& shape, std::string &encoded);
void c2json_uint16(const uint16_t *data, const std::vector<unsigned>& shape, std::string &encoded);

void c2json_int32(const int32_t *data, const std::vector<unsigned>& shape, std::string &encoded);
void c2json_uint32(const uint32_t *data, const std::vector<unsigned>& shape, std::string &encoded);

void c2json_int64(const int64_t *data, const std::vector<unsigned>& shape, std::string &encoded);
void c2json_uint64(const uint64_t *data, const std::vector<unsigned>& shape, std::string &encoded);

void c2json_float(const float *data, const std::vector<unsigned>& shape, std::string &encoded);
void c2json_double(const double *data, const std::vector<unsigned>& shape, std::string &encoded);



#endif
