#include "Hist2DMap.hh"
#include "UtilsException.hh"
#include "SimpleHists/Hist2D.hh"

Histogram::Hist2DMap::Hist2DMap(unsigned nbinx, double xmin, double xmax,
       unsigned nbiny, double ymin, double ymax)
: m_xbin(nbinx), m_xl(xmin), m_xu(xmax), m_ybin(nbiny), m_yl(ymin), m_yu(ymax)
{
}

Histogram::Hist2DMap::~Hist2DMap()
{
  auto it = m_histmap.begin();
  for ( ; it != m_histmap.end(); ++it)
     delete it->second;
}

void Histogram::Hist2DMap::reset()
{
  auto it = m_histmap.begin();
  for ( ; it != m_histmap.end(); ++it)
     it->second->reset();
}


std::map<unsigned, SimpleHists::Hist2D* >::const_iterator Histogram::Hist2DMap::getHistMapBegin() const
{
  return m_histmap.begin();
}

std::map<unsigned, SimpleHists::Hist2D* >::const_iterator Histogram::Hist2DMap::getHistMapEnd() const
{
  return m_histmap.end();
}
