#!/usr/bin/env python
#enable py3 behaviour in py2.6+ (avoid unicode_literals on purpose!)
from __future__ import division, print_function, absolute_import

import ctypes

_libc = ctypes.CDLL('./libprototype.so')
print ("runnig _load()")
ndarray_to_dblp = lambda a : a.ctypes.data_as(ctypes.POINTER(ctypes.c_double))
ndarray_to_ubtp = lambda a : a.ctypes.data_as(ctypes.POINTER(ctypes.c_ubyte))


def _str2cstr(s):
    #converts any string (str,bytes,unicode) to bytes
    try:
        return s if isinstance(s,bytes) else s.encode('ascii')
    except UnicodeEncodeError:
        #Attempt with file-system encoding, in case of non-ASCII path names:
        return s.encode(sys.getfilesystemencoding())

def _cstr2str(s):
    #converts bytes object to str (unicode in py3, bytes in py2)
    try:
        return s if isinstance(s,str) else s.decode('ascii')
    except UnicodeDecodeError:
        return s.decode(sys.getfilesystemencoding())


def _wrap(fct_name,restype,argtypes,take_ref = False, hide=False, error_check=True):
    assert isinstance(argtypes,tuple)
    raw=getattr(_libc,fct_name)
    raw.argtypes=argtypes
    raw.restype=restype

    if take_ref:
        assert len(argtypes)==1
        fct = lambda arg : raw(ctypes.byref(arg))
    else:
        fct = lambda *args : raw(*args)
    if error_check:
        #NB: we should read about return types in the ctypes tutorial. Apparently one
        #can just set an error checking function as the restype.
        raw_fct = fct
        def fcte(*aaa):
            r = raw_fct(*aaa)
            # if _ncerror(): fixme:
            #     _raise_err()
            # return r
        fct=fcte
    if not hide:
        functions[fct_name] = fct
    return fct

#_ncerror       = _wrap('ncrystal_error',ctypes.c_int,tuple(),hide=True,error_check=False)


class Parser_Parserbase_t(ctypes.Structure):
     _fields_ = [('internal', ctypes.c_void_p)]
#


class ParserBase(ctypes.Structure):
    """Base class for Parsers"""
    def __init__(self):
        self._Parser_read_uint32 = _wrap('Parser_read_uint32', ctypes.POINTER(ctypes.c_uint) ,(Parser_Parserbase_t,ctypes.c_ubyte
         ,ctypes.POINTER(ctypes.c_uint) ),hide=True)

        _create_detectorbase = _wrap('create_detectorbase', (Parser_Parserbase_t)  , (), hide=True)
        self._rawobj = _create_detectorbase()

    def read_uint32(self, pt_in): #fixme
        data=0
        self._Parser_read_uint32(self._rawobj, pt_in, data)
        return data

ParserBase()
