#include <cstdio>

#include "ParserHe3.hh"
#include "UtilsException.hh"

Parser::ParserHe3::ParserHe3()
:ParserBase()
{
}

Parser::ParserHe3::~ParserHe3()
{
}

void Parser::ParserHe3::readHeader(const uint8_t*& pt, const Parser::ParserHe3::Header *header) const
{
  //Header is POD data
  error_assert(*pt == PACK_START);

  header = reinterpret_cast<const Header *>(pt);
  pt += 8;

  // printf("""\nheader:\n  flag 0x%x, instrument 0x%x, detc type 0x%x, module 0x%x\n"""
  //        """opt_mode 0x%x fre_div 0x%x version 0x%x data_type 0x%x \n"""
  //   ,header->flag, header->instrument, header->detector_type, header->module
  //   ,header->opt_mode, header->fre_div_mode, header->data_ver, header->data_type );
}

void Parser::ParserHe3::readInfo(const uint8_t*& pt, Info &info) const
{
  uint32_t raw=0;
  read_uint32(pt, info.t0_count);
  read_uint32(pt, raw);
  info.hit_cnt = (raw >> 18) & MASK_14;
  info.sample_num_n = (raw >> 6) & MASK_12;
  info.sample_num_bl = raw & MASK_6;

  // printf("info: \n  t0_cnt %d, hit_cnt %d, n %d, m %d\n"
  //    ,info.t0_count,  info.hit_cnt, info.sample_num_n, info.sample_num_bl);
}
void Parser::ParserHe3::printInfo(const uint8_t* pt) const
{
  uint32_t raw=0;
  Info info;
  read_uint32(pt, info.t0_count);
  read_uint32(pt, raw);
  info.hit_cnt = (raw >> 18) & MASK_14;
  info.sample_num_n = (raw >> 6) & MASK_12;
  info.sample_num_bl = raw & MASK_6;
  printf("info: \n  t0_cnt %d, hit_cnt %d, n %d, m %d\n"
     ,info.t0_count,  info.hit_cnt, info.sample_num_n, info.sample_num_bl);
}


void Parser::ParserHe3::readHit( const uint8_t*& pt, Hit &hit) const
{
  error_assert( ((*pt>>4) & MASK_4)  == DATA_START);

  uint32_t raw=0;
  read_uint32(pt, raw);
  hit.time = raw & MASK_24;
  hit.tube_id = (raw>>24) & MASK_4;
  //fixme:
  // //tube_id from DAQ 7 8 9 11, corresponding to 1 2 3 4 in subsequent analysis
  // hit.tube_id = hit.tube_id==11? hit.tube_id-7:hit.tube_id-6;
  read_uint32(pt, raw);
  hit.upper_baseline = raw & MASK_20;
  read_uint32(pt, raw);
  hit.lower_baseline = raw & MASK_20;
  read_uint32(pt, raw);
  hit.upper_charge = (raw>>16) & MASK_16;
  hit.lower_charge = raw & MASK_16;

  // printf("hit:const uint8_t*&tube_id %x, upper_baseline %d, lower_baseline %d\n  upper_charge %d, lower_charge %d\n"
  //   ,hit.time,  hit.tube_id, hit.upper_baseline, hit.lower_baseline,hit.upper_charge, hit.lower_charge);
}

bool Parser::ParserHe3::findEnd(const uint8_t* pt, const uint8_t*& end) const
{
  if(*pt != PACK_START)
    return false;

  //extract number of hit
  uint32_t tmp = *(pt+12)<<8;
  tmp += *(pt+13);
  uint32_t hitnum = tmp >> 2;

  //estimate package total size
  uint32_t data_payload_size = hitnum*16;
  uint32_t estTotSize = 16 + data_payload_size + 8;

  //check the second flag in a package
  if(*(pt + estTotSize -8) !=  PACK_END)
    return false;

  uint32_t totByteCount = 0;
  const uint8_t * pos = pt+estTotSize-4;
  read_uint32(pos ,totByteCount);

  end =  pt + totByteCount;
  return estTotSize==totByteCount?true:false;
}

bool Parser::ParserHe3::is_valid(const uint8_t* pt) const
{
  const uint8_t* tmp;
  return findEnd(pt,tmp);
}
