#include "ParserBase.hh"
#include "UtilsException.hh"

#include <cstdio>
Parser::ParserBase::ParserBase()
{

}

Parser::ParserBase::~ParserBase()
{

}


void Parser::ParserBase::read_uint32_many(const uint8_t*& pt, std::vector<uint32_t> &u32_vec, unsigned num) const
{
  if(u32_vec.size()!=num)
    u32_vec.resize(num);

  for(unsigned i=0;i<num;i++) {
    read_uint32(pt, u32_vec[i]);
  }
}


bool Parser::ParserBase::findNextPackage(const uint8_t*& start, const uint8_t * const stream_end, const uint8_t*& pkgend, uint64_t &offset) const
{
  //fixme: detect zero padding data
  error_assert_always(start<stream_end);
  offset=0;
  for(;start!=stream_end;start++,offset++)
  {
    if(findEnd(start,pkgend))
    {
      if(offset)
        printf("Found next package in the stream with offst %ld, start at %ld to the end of stream\n", offset, stream_end-start); //fixme : logge
      return true;
    }
  }
  return false;
}
