#ifndef Parser_ParserHe3_hh
#define Parser_ParserHe3_hh

#include <stdint.h>
#include <vector>

#include "ParserBase.hh"

//This class reads segments of raw package from He3 detector.
namespace Parser {

  class EXPORT_SYMBOL ParserHe3: public ParserBase {
  public:
    struct Header {
      uint8_t flag; //0xFA
      uint8_t instrument;
      uint8_t detector_type;
      uint8_t module;
      uint8_t opt_mode;
      uint8_t fre_div_mode;
      uint8_t data_ver;
      uint8_t data_type;
    };

    struct Info {
      uint32_t t0_count;
      uint16_t hit_cnt;
      uint16_t sample_num_n; //sampled number of points on the waveform
      uint16_t sample_num_bl; //sampled number of points on the baseline
      Info() : t0_count(), hit_cnt(), sample_num_n(), sample_num_bl() {}
    };

    struct Hit {
      uint32_t time;
      uint32_t upper_baseline;
      uint32_t lower_baseline;
      uint16_t upper_charge;
      uint16_t lower_charge;
      uint8_t tube_id;
    };



   enum FLAG: uint32_t {
     DATA_START  = 0XE,
     PACK_START  = 0xFA,
     PACK_END  = 0XFB
   };


  public:
    ParserHe3();
    virtual ~ParserHe3();
    void readHeader(const uint8_t*& pt, const Header *header) const;
    void readInfo(const uint8_t*& pt, Info &info) const;
    //input pt remain untouched
    void printInfo(const uint8_t* pt) const;

    //it_payload should point at the data flag 0xE, otherwise time is set to zero.
    void readHit( const uint8_t*& pt_payload, Hit &hit) const ;

    bool findEnd(const uint8_t* pt, const uint8_t*& end) const override;
    bool is_valid(const uint8_t* pt) const override;

  private:

  };
}
#endif
