#ifndef Parser_PackageMWPCold_hh
#define Parser_PackageMWPCold_hh

#include <map>
#include "ParserMWPC.hh"
#include <fstream>

namespace Histogram {
  class Hist2DMap;
}

namespace SimpleHists {
  class Hist1D;
}

//This class reads information from a full package.
namespace Parser {
  //fixme :  put m_detector_half_length and m_tof2us elsewhere
  class EXPORT_SYMBOL PackageMWPCold: public ParserMWPC {
  public:
    PackageMWPCold(double threshold, double time_window );
    ~PackageMWPCold() override;

    //returns false when reach the end of the data stream
    bool readNextPackage(const uint8_t*& pt, const uint8_t * const stream_end, Histogram::Hist2DMap &hitmap,
                         SimpleHists::Hist1D &qhist) const;
    void write(std::ofstream &file, const char *filename);
    void print() const;

    double getChargeThreshold() const;
    void setChargeThreshold(double charge);

  private:
    double m_charge_threshold;
    uint64_t m_time_window;
    mutable uint32_t m_last_t0;
    mutable std::multimap<uint32_t,uint32_t> m_tof_cq_map; //<TOF, chanel+Q>

    void pushbackRawData(unsigned eventmapnum, const uint8_t *&pt) const;

    inline void getChannelCharge(uint32_t in, uint8_t& channel, uint16_t& charge ) const;

  };

  inline void Parser::PackageMWPCold::getChannelCharge(uint32_t in, uint8_t& channel, uint16_t& charge) const
  {
    channel = in>>24;
    uint16_t baseline = ((in>>12)&MASK_12) ; //fixme the document states the baseline value is the combination of 8 samples!?
    uint16_t chage = (in&MASK_12) ;
    charge = chage>baseline ? chage-baseline: 0  ; //fixme emit warning if overflowed
  }
}
#endif
