#include "DimServer.hh"
#ifdef __cplusplus
extern "C"{
#include "dic.h"
}
#endif


DimServer::DimServer()
:m_dimServerID(0)
{
  char* envNode = getenv("DIM_DNS_NODE");
  char* envPort = getenv("DIM_DNS_PORT");
  // if(envNode and envPort) {
  // LogInfo << "DIM_DNS_NODE: " << envNode << std::endl;
  // LogInfo << "DIM_DNS_PORT: " << envPort << std::endl;
  static int no_link = -1;
  //xx. https://dim.web.cern.ch/dimCdic.html#dic_info_service_stamped
  // unsigned int dic_info_service_stamped (name, type, timeout, address, size, user_routine, tag, fill_address, fill_size)
  // 1. char *name: service name, same name used by server when declaring the service.
  // 2. int type;
  //    Type of service, constants defined are: ONCE_ONLY, TIMED or MONITORED:
  //    MONITORED: The client will receive the data when the server updates it (by calling dis_update_service()),
  //  but also at regular intervals if the "timeout" parameter is different from 0. The "timeout" parameter can be set to 0 to receive data only on server update.
  // 3. int timeout;
  //   For a TIMED or MONITORED service "timeout" indicates the time interval the server should use to send new data, for ONCE_ONLY  services it indicates the time after
  //   which the service is considered to have failed.
  // 4. int *address;
  //    Address of the buffer where to store the data when the service returns from the server. This parameter can be set to 0 and only the callback routine will be executed.
  // 5. int size;
  //    The size in bytes of the previous buffer (if specified).
  // 6. void *user_routine;
  //    The address of a routine to be executed when new data is returned from the server, the parameters of this routine will be specified later in this document.
  //   Can be set to 0 if no callback routine is necessary.
  // 7. long tag;
  //    A parameter to be sent to the user_routine in order to identify the service that has completed.
  // 8. int *fill_address;
  //    Address of a buffer containing data to be stored in the service buffer or passed to the callback routine in case the service doesn't succeed.
  // 9. int fill_size;
  //    The size in bytes of the previous buffer.

  // return unsigned int service_id;
  // The service identifier, to be used when (if) releasing the service.

  m_dimServerID = dic_info_service_stamped( "what is the name??", MONITORED, 0, 0, 0,
   &DimServer::eventDataArrived, 1200, &no_link, 4 );
  // ERROR_THROW("Failed to establish dim connection");
  // else throw SniperException("DIM_DNS_NODE or DIM_DNS_PORT undefined!");
}

DimServer::~DimServer()
{

}

unsigned DimServer::dostuff()
{
  return 1;
}

void DimServer::eventDataArrived(void *tag, void *buf, int *size )
{
  if( *static_cast<const int*>(tag) == 1200)
  {
    std::unique_lock<std::mutex> mlock(m_mutex);
    m_data.emplace_back(std::vector<uint8_t> ( (uint8_t*)buf, (uint8_t*)buf+(*size) ) );
    // std::future<unsigned> task = std::async(std::launch::async, DimServer::dostuff);
    m_tasks.emplace_back(std::async(std::launch::async, DimServer::dostuff));
  }
}
