#include "DaqTask.hh"
#include <thread>
#include <chrono>
#include <iostream>
#include "PackageHe3.hh"

DaqTask::DaqTask(uint8_t* begin, uint8_t* end)
:m_data(begin, end), m_time_s(0), m_time_ms(0)
{

}

DaqTask::~DaqTask()
{

}


uint64_t DaqTask::readyAndValid()
{
  std::lock_guard<std::mutex> guard(m_run_mutex);

  if(!m_future.valid())
    return 0;
  auto status = m_future.wait_for(std::chrono::milliseconds(0));
  return status == std::future_status::ready ? m_future.get() : 0;
}

void DaqTask::start()
{
  std::lock_guard<std::mutex> guard(m_run_mutex);
  m_future = std::async(std::launch::async, &DaqTask::run, this).share();
}

uint64_t DaqTask::run()
{
  // printf("running. m_data size %zu\n", m_data.size());

  std::lock_guard<std::mutex> guard(m_run_mutex);
  std::this_thread::sleep_for(std::chrono::milliseconds(10));

  const uint8_t * abuf = m_data.data();
  int event_cnt=0;
  std::vector<Parser::HitInfo> hitinfo;
  Parser::PackageHe3 he3(0.);

  while(he3.readNextPackage(abuf, m_data.data()+m_data.size(), hitinfo))
  {
    event_cnt+=hitinfo.size();
  }

  if(event_cnt)
  {
    char fn[200];
    sprintf(fn,"data/%d_%d.dat",m_time_s, m_time_ms);
    FILE *datafile = fopen(fn, "wb");
    fwrite (m_data.data() , sizeof(char), m_data.size(), datafile);
    fclose(datafile);
    // printf("%s, %d events\n", fn, event_cnt);
  }

  uint64_t shiftedEvt = event_cnt*4294967296;
  return (uint64_t)m_data.size() +  shiftedEvt;
}

void DaqTask::setTime(int second, int ms)
{
  std::lock_guard<std::mutex> guard(m_run_mutex);
  m_time_s = second;
  m_time_ms = ms;
}
void DaqTask::getTime(int &second, int &ms) const
{
  std::lock_guard<std::mutex> guard(m_run_mutex);
  second = m_time_s;
  ms = m_time_ms;
}

// Move initialization
DaqTask::DaqTask(DaqTask&& other) {
  std::lock_guard<std::mutex> lock(other.m_run_mutex);
  m_data = std::move(other.m_data);
  m_future = std::move(other.m_future);
  m_time_s = other.m_time_s;
  m_time_ms = other.m_time_ms;
  other.m_time_s = 0;
  other.m_time_ms = 0;
};

// Copy initialization
DaqTask::DaqTask(const DaqTask& other) {
  std::lock_guard<std::mutex> lock(other.m_run_mutex);
  m_data = other.m_data;
  m_future = other.m_future;
  m_time_s = other.m_time_s;
  m_time_ms = other.m_time_ms;
};

// Move assignment
DaqTask& DaqTask::operator = (DaqTask&& other) {
  std::lock(m_run_mutex, other.m_run_mutex);
  std::lock_guard<std::mutex> self_lock(m_run_mutex, std::adopt_lock);
  std::lock_guard<std::mutex> other_lock(other.m_run_mutex, std::adopt_lock);
  m_data = std::move(other.m_data);
  m_future = std::move(other.m_future);
  m_time_s = other.m_time_s;
  m_time_ms = other.m_time_ms;
  other.m_time_s = 0;
  other.m_time_ms = 0;
  return *this;
};

// Copy assignment
DaqTask& DaqTask::operator = (const DaqTask& other) {
  std::lock(m_run_mutex, other.m_run_mutex);
  std::lock_guard<std::mutex> self_lock(m_run_mutex, std::adopt_lock);
  std::lock_guard<std::mutex> other_lock(other.m_run_mutex, std::adopt_lock);
  m_data = other.m_data;
  m_future = other.m_future;
  m_time_s = other.m_time_s;
  m_time_ms = other.m_time_ms;
  return *this;
};
