#ifndef DimRecv_Retriver_hh
#define DimRecv_Retriver_hh

#include <stdint.h>
#include <vector>
#include <future>
#include <mutex>
#include <unordered_map>
#include "UtilsException.hh"


//This is the base class for decoding detector raw data.
class Retriver {

public:
  Retriver();
  virtual ~Retriver();

private:
  unsigned int m_dimServerID;
  static std::mutex m_mutex;
  static unsigned dostuff();
  static void eventDataArrived(void *tag, void *buf, int *size);
  static std::vector< std::future<unsigned> > m_tasks;
  static std::vector< std::vector<uint8_t> > m_data;

};

std::mutex Retriver::m_mutex;
std::vector< std::future<unsigned> > Retriver::m_tasks;
std::vector< std::vector<uint8_t> > Retriver::m_data;
#endif
