#ifndef DimRecv_DimServer_hh
#define DimRecv_DimServer_hh

#include <stdint.h>
#include <vector>
#include <future>
#include <mutex>
#include <unordered_map>
#include "UtilsException.hh"


//This is the base class for decoding detector raw data.
class DimServer {

public:
  DimServer();
  virtual ~DimServer();

private:
  unsigned int m_dimServerID;
  static std::mutex m_mutex;
  static unsigned dostuff();
  static void eventDataArrived(void *tag, void *buf, int *size);
  static std::vector< std::future<unsigned> > m_tasks;
  static std::vector< std::vector<uint8_t> > m_data;

};

std::mutex DimServer::m_mutex;
std::vector< std::future<unsigned> > DimServer::m_tasks;
std::vector< std::vector<uint8_t> > DimServer::m_data;
#endif
