#ifndef DimRecv_DaqTask_hh
#define DimRecv_DaqTask_hh

#include <future>
#include <vector>
#include <mutex>

class DaqTask {
public:
  DaqTask(uint8_t* begin, uint8_t* end);
  virtual ~DaqTask();

  // Move initialization
  DaqTask(DaqTask&& other) ;
  // Copy initialization
  DaqTask(const DaqTask& other) ;
  // Move assignment
  DaqTask& operator = (DaqTask&& other) ;
  // Copy assignment
  DaqTask& operator = (const DaqTask& other) ;


  uint64_t readyAndValid();
  void start();
  void setTime(int second, int ms);
  void getTime(int &second, int &ms) const;


private:
  std::vector<uint8_t> m_data;
  std::shared_future<uint64_t> m_future;
  int m_time_s, m_time_ms; //since 1/1/1970, in seconds
  mutable std::mutex m_run_mutex;

  uint64_t run();
};

#endif
