// The Server publishes one service (integer value)
// and updates it from time to time (when it changes):
#include <iostream>
#include <vector>
#include <thread>
#include <chrono>
#include <time.h>
#include <dis.hxx>

int main(int argc, char *argv[])
{
	int interval = 200;
	if(argc==2)
	  interval = atoi(argv[1]);

	std::cout << "Starting server..." << std::endl;
	std::cout << "event interval: " << interval << " ms "<<std::endl;

	std::vector<char> data(2000000);
	for(auto &v:data)
	  v='C';
  int run = 0;
  DimService charServ("DAQ", data.data() );
	std::cout << "data size: " << data.size() << std::endl;

  DimServer::start("RUN_INFO");
	auto start = std::chrono::system_clock::now();
	long totsize =0;
  while(1)
  {
		std::this_thread::sleep_for(std::chrono::milliseconds(interval));
		// std::cout << "run " << run << std::endl;
		// sprintf(data,"%s %d","xx is vgl", run);
		charServ.updateService();

		run++;
		totsize += data.size();

		std::chrono::duration<double> elapsed_seconds = std::chrono::system_clock::now()-start;
		double t = elapsed_seconds.count();
    if(t >1.0 )
		{
			std::cout << '\r'
	          << "Run " << run
						<< ". Elapsed " << t*1000.
						<< "ms. Data rate: " <<  totsize/1024./1024/t
						<< "MB/s." << std::flush;
		  totsize =0 ;
			start = std::chrono::system_clock::now();
		}

  }
}
