#include "RedisHelper.hh"
#include <iostream>
#include <vector>
#include <typeinfo>

int main() {

  const char *python_ref[] =
  {"{\"dtype\": \"int8\", \"shape\": [6], \"__ndarray__\": \"AQIDBDJ/\"}",
  "{\"dtype\": \"uint8\", \"shape\": [6], \"__ndarray__\": \"AQIDBDJ/\"}",
  "{\"dtype\": \"int16\", \"shape\": [6], \"__ndarray__\": \"AQACAAMABAAyAH8A\"}",
  "{\"dtype\": \"uint16\", \"shape\": [6], \"__ndarray__\": \"AQACAAMABAAyAH8A\"}",
  "{\"dtype\": \"int32\", \"shape\": [6], \"__ndarray__\": \"AQAAAAIAAAADAAAABAAAADIAAAB/AAAA\"}",
  "{\"dtype\": \"uint32\", \"shape\": [6], \"__ndarray__\": \"AQAAAAIAAAADAAAABAAAADIAAAB/AAAA\"}",
  "{\"dtype\": \"int64\", \"shape\": [6], \"__ndarray__\": \"AQAAAAAAAAACAAAAAAAAAAMAAAAAAAAABAAAAAAAAAAyAAAAAAAAAH8AAAAAAAAA\"}",
  "{\"dtype\": \"uint64\", \"shape\": [6], \"__ndarray__\": \"AQAAAAAAAAACAAAAAAAAAAMAAAAAAAAABAAAAAAAAAAyAAAAAAAAAH8AAAAAAAAA\"}",
  "{\"dtype\": \"float32\", \"shape\": [6], \"__ndarray__\": \"AACAPwAAAEAAAEBAAACAQAAASEIAAP5C\"}",
  "{\"dtype\": \"float64\", \"shape\": [6], \"__ndarray__\": \"AAAAAAAA8D8AAAAAAAAAQAAAAAAAAAhAAAAAAAAAEEAAAAAAAABJQAAAAAAAwF9A\"}"};


  std::vector<std::string> python_ref_vec(python_ref, python_ref+10);

  std::string str;

  c2json_int8(std::vector<int8_t> {1,2,3,4,50,127}.data(), std::vector<unsigned>{6}, str);
  if(str!=python_ref[0]) {
    std::cout << "failed to pass test " << 0 << std::endl;
    return 1;
  }
  c2json_uint8(std::vector<uint8_t> {1,2,3,4,50,127}.data(), std::vector<unsigned>{6}, str);
  if(str!=python_ref[1]) {
    std::cout << "failed to pass test " << 1 << std::endl;
    return 1;
  }
  c2json_int16(std::vector<int16_t> {1,2,3,4,50,127}.data(), std::vector<unsigned>{6}, str);
  if(str!=python_ref[2]) {
    std::cout << "failed to pass test " << 2 << std::endl;
    return 1;
  }
  c2json_uint16(std::vector<uint16_t> {1,2,3,4,50,127}.data(), std::vector<unsigned>{6}, str);
  if(str!=python_ref[3]) {
    std::cout << "failed to pass test " << 3 << std::endl;
    return 1;
  }
  c2json_int32(std::vector<int32_t> {1,2,3,4,50,127}.data(), std::vector<unsigned>{6}, str);
  if(str!=python_ref[4]) {
    std::cout << "failed to pass test " << 4 << std::endl;
    return 1;
  }
  c2json_uint32(std::vector<uint32_t> {1,2,3,4,50,127}.data(), std::vector<unsigned>{6}, str);
  if(str!=python_ref[5]) {
    std::cout << "failed to pass test " << 5 << std::endl;
    return 1;
  }
  c2json_int64(std::vector<int64_t> {1,2,3,4,50,127}.data(), std::vector<unsigned>{6}, str);
  if(str!=python_ref[6]) {
    std::cout << "failed to pass test " << 6 << std::endl;
    return 1;
  }
  c2json_uint64(std::vector<uint64_t> {1,2,3,4,50,127}.data(), std::vector<unsigned>{6}, str);
  if(str!=python_ref[7]) {
    std::cout << "failed to pass test " << 7 << std::endl;
    return 1;
  }
  c2json_float(std::vector<float> {1,2,3,4,50,127}.data(), std::vector<unsigned>{6}, str);
  if(str!=python_ref[8]) {
    std::cout << "failed to pass test " << 8 << std::endl;
    return 1;
  }
  c2json_double(std::vector<double> {1,2,3,4,50,127}.data(), std::vector<unsigned>{6}, str);
  if(str!=python_ref[9]) {
    std::cout << "failed to pass test " << 9 << std::endl;
    return 1;
  }


  std::cout << "passed all python cross comparison. " << std::endl;



  //reference generated by python as
  // import base64
  // bytes_data = range(0,256)
  // d="".join(map(chr, bytes_data))
  // base64.b64encode(d)

  std::string ref = "AAECAwQFBgcICQoLDA0ODxAREhMUFRYXGBkaGxwdHh8gISIjJCUmJygpKissLS4vMDEyMzQ1Njc4OTo7PD0+P0BBQkNERUZHSElKS0xNTk9QUVJTVFVWV1hZWltcXV5fYGFiY2RlZmdoaWprbG1ub3BxcnN0dXZ3eHl6e3x9fn+AgYKDhIWGh4iJiouMjY6PkJGSk5SVlpeYmZqbnJ2en6ChoqOkpaanqKmqq6ytrq+wsbKztLW2t7i5uru8vb6/wMHCw8TFxsfIycrLzM3Oz9DR0tPU1dbX2Nna29zd3t/g4eLj5OXm5+jp6uvs7e7v8PHy8/T19vf4+fr7/P3+/w==";
  unsigned char bytes[256];
  for(unsigned i=0;i<256;i++)
    bytes[i]=i;

  std::string encoded;
  base64_encode(bytes , 256, encoded) ;
  if(encoded!=ref) {
    std::cout <<  "error!" << std::endl;
    return 2;
  }
  else
    std::cout << "passed!" << std::endl;
  return 0;

}
