# - Find pvData
# Find the native pvData headers and libraries.
#
#  pvData_INCLUDE_DIRS - where to find pvData/pvData.h, etc.
#  pvData_LIBRARIES    - List of libraries when using pvData.
#  pvData_FOUND        - True if pvData found.

# Look for the header file.
SET(CMAKE_INCLUDE_PATH ${CMAKE_INSTALL_PREFIX}/include)
SET(CMAKE_LIBRARY_PATH ${CMAKE_INSTALL_PREFIX}/lib)

FIND_PATH(pvData_INCLUDE_DIR NAMES pv/pvData.h)
MARK_AS_ADVANCED(pvData_INCLUDE_DIRS)

# Look for the library.
FIND_LIBRARY(pvData_LIBRARY NAMES libpvData.so)
MARK_AS_ADVANCED(pvData_LIBRARIES)

# handle the QUIETLY and REQUIRED arguments and set pvData_FOUND to TRUE if 
# all listed variables are TRUE
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(pvData DEFAULT_MSG pvData_LIBRARY pvData_INCLUDE_DIR)

MESSAGE(STATUS "pvData include path: " ${pvData_INCLUDE_DIR})

IF(pvData_INCLUDE_DIR AND pvData_LIBRARY)
  SET(pvData_FOUND TRUE)
  SET(pvData_LIBRARIES    ${pvData_LIBRARY}/libpvData.so)
  SET(pvData_INCLUDE_DIRS ${pvData_INCLUDE_DIR})
ELSE()
  SET(pvData_FOUND FALSE)
  SET(pvData_LIBRARIES)
  SET(pvData_INCLUDE_DIRS)
ENDIF()

