# - Find DroNECore
# Find the native DroNECoreWorld headers and libraries.
#
#  DroNECore_INCLUDE_DIRS - where to find DroNECore/DroNE.h, etc.
#  DroNECore_LIBRARIES    - List of libraries when using DroNECoreWorld.
#  DroNECore_FOUND        - True if DroNECore found.

# Look for the header file.
SET(CMAKE_INCLUDE_PATH ${CMAKE_INSTALL_PREFIX}/include)
SET(CMAKE_LIBRARY_PATH ${CMAKE_INSTALL_PREFIX}/lib)

FIND_PATH(DroNECore_INCLUDE_DIR NAMES DroNECore/DroNE.h)
MARK_AS_ADVANCED(DroNECore_INCLUDE_DIRS)

# Look for the library.
FIND_LIBRARY(DroNECore_LIBRARY NAMES DroNECore)#libDroNECore.so)
MARK_AS_ADVANCED(DroNECore_LIBRARIES)

# handle the QUIETLY and REQUIRED arguments and set DroNECore_FOUND to TRUE if 
# all listed variables are TRUE
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(DroNECore DEFAULT_MSG DroNECore_LIBRARY DroNECore_INCLUDE_DIR)

MESSAGE(STATUS "DroNECore include path: " ${DroNECore_INCLUDE_DIR})

IF(DroNECore_INCLUDE_DIR AND DroNECore_LIBRARY)#DataSvc_FOUND)
  SET(DroNECore_FOUND TRUE)
  SET(DroNECore_LIBRARIES    ${DroNECore_LIBRARY}/libDroNECore.so)
  SET(DroNECore_INCLUDE_DIRS ${DroNECore_INCLUDE_DIR})
ELSE()
  SET(DroNECore_FOUND FALSE)
  SET(DroNECore_LIBRARIES)
  SET(DroNECore_INCLUDE_DIRS)
ENDIF()

