# - Find SniperKernelWorld
# Find the native SniperKernelWorld headers and libraries.
#
#  SniperKernel_INCLUDE_DIRS - where to find SniperKernel/Sniper.h, etc.
#  SniperKernel_LIBRARIES    - List of libraries when using SniperKernelWorld.
#  SniperKernel_FOUND        - True if SniperKernel found.

# Look for the header file.
SET(CMAKE_INCLUDE_PATH ${CMAKE_INSTALL_PREFIX}/include)
SET(CMAKE_LIBRARY_PATH ${CMAKE_INSTALL_PREFIX}/lib)

FIND_PATH(Dim_INCLUDE_DIR NAMES dim.h)
MARK_AS_ADVANCED(Dim_INCLUDE_DIRS)

# Look for the library.
FIND_LIBRARY(Dim_LIBRARY NAMES dim)
MARK_AS_ADVANCED(Dim_LIBRARIES)

# handle the QUIETLY and REQUIRED arguments and set SniperKernel_FOUND to TRUE if 
# all listed variables are TRUE
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(Dim DEFAULT_MSG Dim_LIBRARY Dim_INCLUDE_DIR)

MESSAGE(STATUS "Dim include path: " ${Dim_INCLUDE_DIR})

IF(Dim_INCLUDE_DIR AND Dim_LIBRARY)#DIM_FOUND)
  SET(Dim_FOUND TRUE)	
  SET(Dim_LIBRARIES    ${Dim_LIBRARY}/libdim.so)
  SET(Dim_INCLUDE_DIRS ${Dim_INCLUDE_DIR})
ELSE()#IF(NOT Dim_FOUND)
  SET(Dim_FOUND FALSE)
  SET(Dim_LIBRARIES)
  SET(Dim_INCLUDE_DIRS)
ENDIF()

