# - Find pvAccess
# Find the native pvAccess headers and libraries.
#
#  pvAccess_INCLUDE_DIRS - where to find pvAccess/pvAccess.h, etc.
#  pvAccess_LIBRARIES    - List of libraries when using pvAccess.
#  pvAccess_FOUND        - True if pvAccess found.

# Look for the header file.
SET(CMAKE_INCLUDE_PATH ${CMAKE_INSTALL_PREFIX}/include)
SET(CMAKE_LIBRARY_PATH ${CMAKE_INSTALL_PREFIX}/lib)

FIND_PATH(pvAccess_INCLUDE_DIR NAMES pvAccess.h)
MARK_AS_ADVANCED(pvAccess_INCLUDE_DIRS)

# Look for the library.
FIND_LIBRARY(pvAccess_LIBRARY NAMES pvAccess)
MARK_AS_ADVANCED(pvAccess_LIBRARIES)

# handle the QUIETLY and REQUIRED arguments and set pvAccess_FOUND to TRUE if 
# all listed variables are TRUE
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(pvAccess DEFAULT_MSG pvAccess_LIBRARY pvAccess_INCLUDE_DIR)

MESSAGE(STATUS "pvAccess include path: " ${pvAccess_INCLUDE_DIR})

IF(pvAccess_INCLUDE_DIR AND pvAccess_LIBRARY)
  SET(pvAccess_FOUND TRUE)
  SET(pvAccess_LIBRARIES    ${pvAccess_LIBRARY})
  SET(pvAccess_INCLUDE_DIRS ${pvAccess_INCLUDE_DIR})
ELSE()
  SET(pvAccess_FOUND FALSE)
  SET(pvAccess_LIBRARIES)
  SET(pvAccess_INCLUDE_DIRS)
ENDIF()

