# - Find DataWorld
# Find the native DataWorld headers and libraries.
#
#  Data_INCLUDE_DIRS - where to find Data/RawData.h, etc.
#  Data_LIBRARIES    - List of libraries when using DataWorld.
#  Data_FOUND        - True if Data found.

# Look for the header file.
SET(CMAKE_INCLUDE_PATH ${CMAKE_INSTALL_PREFIX}/include)
SET(CMAKE_LIBRARY_PATH ${CMAKE_INSTALL_PREFIX}/lib)

FIND_PATH(Data_INCLUDE_DIR NAMES Data/Pulse.h)
MARK_AS_ADVANCED(Data_INCLUDE_DIRS)

# Look for the library.
FIND_LIBRARY(Data_LIBRARY NAMES Data)
MARK_AS_ADVANCED(Data_LIBRARIES)

# handle the QUIETLY and REQUIRED arguments and set Data_FOUND to TRUE if 
# all listed variables are TRUE
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(Data DEFAULT_MSG Data_LIBRARY Data_INCLUDE_DIR)

IF(Data_INCLUDE_DIR AND Data_LIBRARY)
  SET(Data_FOUND TRUE)
  SET(Data_LIBRARIES    ${Data_LIBRARY})
  SET(Data_INCLUDE_DIRS ${Data_INCLUDE_DIR})
ELSE()
  SET(Data_FOUND FALSE)
  SET(Data_LIBRARIES)
  SET(Data_INCLUDE_DIRS)
ENDIF()

